/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema.table;

import java.util.HashMap;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.StringUtils;

public class MemberColumnMappingImpl
implements MemberColumnMapping {
    protected AbstractMemberMetaData mmd;
    protected TypeConverter typeConverter;
    protected Map<FieldRole, TypeConverter> componentConverters;
    protected Column[] columns;

    public MemberColumnMappingImpl(AbstractMemberMetaData mmd, Column col) {
        this.mmd = mmd;
        this.columns = new Column[]{col};
    }

    public MemberColumnMappingImpl(AbstractMemberMetaData mmd, Column[] cols, TypeConverter typeConv) {
        this.mmd = mmd;
        this.columns = cols;
        this.typeConverter = typeConv;
    }

    @Override
    public void setTypeConverter(TypeConverter typeConv) {
        this.typeConverter = typeConv;
    }

    @Override
    public void setTypeConverterForComponent(FieldRole role, TypeConverter conv) {
        if (this.typeConverter != null) {
            throw new NucleusException("Cannot set a component converter for " + this.mmd.getFullFieldName() + " since already has a TypeConverter defined for the field");
        }
        if (role == FieldRole.ROLE_COLLECTION_ELEMENT && !this.mmd.hasCollection()) {
            throw new NucleusException("Cannot set a TypeConverter for the collection element on member " + this.mmd.getFullFieldName() + " since no collection");
        }
        if (!(role != FieldRole.ROLE_MAP_KEY && role != FieldRole.ROLE_MAP_VALUE || this.mmd.hasMap())) {
            throw new NucleusException("Cannot set a TypeConverter for the map key/value on member " + this.mmd.getFullFieldName() + " since no map");
        }
        if (this.componentConverters == null) {
            this.componentConverters = new HashMap<FieldRole, TypeConverter>();
        }
        this.componentConverters.put(role, conv);
    }

    @Override
    public AbstractMemberMetaData getMemberMetaData() {
        return this.mmd;
    }

    @Override
    public Column getColumn(int position) {
        if (position >= this.getNumberOfColumns()) {
            return null;
        }
        return this.columns[position];
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns != null ? this.columns.length : 0;
    }

    @Override
    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public TypeConverter getTypeConverterForComponent(FieldRole role) {
        if (this.componentConverters != null) {
            return this.componentConverters.get((Object)role);
        }
        return null;
    }

    public String toString() {
        return "Member: " + this.mmd.getFullFieldName() + " converter=" + this.typeConverter + " columns=" + StringUtils.objectArrayToString(this.columns);
    }
}

