/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.SingleFieldId;

public class ObjectId
extends SingleFieldId {
    private Object key;
    static final Map<Class, StringConstructor> stringConstructorMap = new HashMap<Class, StringConstructor>();
    private static DateFormat dateFormat;

    public ObjectId(Class pcClass, Object param) {
        super(pcClass);
        this.assertKeyNotNull(param);
        String paramString = null;
        String keyString = null;
        String keyClassName = null;
        if (param instanceof String) {
            paramString = (String)param;
            if (paramString.length() < 3) {
                throw new NucleusUserException("ObjectId constructor from String was expecting a longer string than " + paramString);
            }
            int indexOfDelimiter = paramString.indexOf(":");
            if (indexOfDelimiter < 0) {
                throw new NucleusUserException("ObjectId constructor from String was expecting a delimiter of : but not present!");
            }
            keyString = paramString.substring(indexOfDelimiter + 1);
            keyClassName = paramString.substring(0, indexOfDelimiter);
            this.key = ObjectId.construct(keyClassName, keyString);
        } else {
            this.key = param;
        }
        this.hashCode = this.targetClassName.hashCode() ^ this.key.hashCode();
    }

    public ObjectId() {
    }

    public Object getKey() {
        return this.key;
    }

    public Object getKeyAsObject() {
        return this.key;
    }

    public String toString() {
        return this.key.getClass().getName() + ":" + this.key.toString();
    }

    @Override
    protected boolean keyEquals(SingleFieldId obj) {
        if (obj instanceof ObjectId) {
            return this.key.equals(((ObjectId)obj).key);
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof ObjectId) {
            ObjectId other = (ObjectId)o;
            int result = super.compare(other);
            if (result == 0) {
                if (other.key instanceof Comparable && this.key instanceof Comparable) {
                    return ((Comparable)this.key).compareTo(other.key);
                }
                throw new ClassCastException("The key class (" + this.key.getClass().getName() + ") does not implement Comparable");
            }
            return result;
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.key);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object registerStringConstructor(Class cls, StringConstructor sc) {
        Map<Class, StringConstructor> map = stringConstructorMap;
        synchronized (map) {
            return stringConstructorMap.put(cls, sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object construct(String className, String keyString) {
        try {
            StringConstructor stringConstructor;
            Class<?> keyClass = Class.forName(className);
            Map<Class, StringConstructor> map = stringConstructorMap;
            synchronized (map) {
                stringConstructor = stringConstructorMap.get(keyClass);
            }
            if (stringConstructor != null) {
                return stringConstructor.construct(keyString);
            }
            return keyClass.getConstructor(String.class).newInstance(keyString);
        }
        catch (Exception ex) {
            throw new NucleusUserException("Exception in Object identity String constructor", ex);
        }
    }

    static {
        ObjectId.registerStringConstructor(Currency.class, new StringConstructor(){

            @Override
            public Object construct(String s) {
                try {
                    return Currency.getInstance(s);
                }
                catch (Exception ex) {
                    throw new NucleusUserException("Exception in ObjectId String constructor for Currency", ex);
                }
            }
        });
        ObjectId.registerStringConstructor(Locale.class, new StringConstructor(){

            @Override
            public Object construct(String s) {
                try {
                    String lang = s;
                    int firstUnderbar = s.indexOf(95);
                    if (firstUnderbar == -1) {
                        return new Locale(lang);
                    }
                    lang = s.substring(0, firstUnderbar);
                    int secondUnderbar = s.indexOf(95, firstUnderbar + 1);
                    if (secondUnderbar == -1) {
                        String country = s.substring(firstUnderbar + 1);
                        return new Locale(lang, country);
                    }
                    String country = s.substring(firstUnderbar + 1, secondUnderbar);
                    String variant = s.substring(secondUnderbar + 1);
                    return new Locale(lang, country, variant);
                }
                catch (Exception ex) {
                    throw new NucleusUserException("Exception in ObjectId String constructor for Locale", ex);
                }
            }
        });
        DateFormat result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedAction<DateFormat>(){

                @Override
                public DateFormat run() {
                    return DateFormat.getDateTimeInstance();
                }
            });
        }
        catch (Exception ex) {
            result = DateFormat.getInstance();
        }
        dateFormat = result;
        ObjectId.registerStringConstructor(Date.class, new StringConstructor(){

            @Override
            public synchronized Object construct(String s) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException ex) {
                    ParsePosition pp = new ParsePosition(0);
                    Date result = dateFormat.parse(s, pp);
                    if (result == null) {
                        String dateFormatPattern = null;
                        dateFormatPattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : "Unknown message";
                        throw new NucleusUserException("Exception in ObjectId String constructor for Date", new Object[]{s, pp.getErrorIndex(), dateFormatPattern});
                    }
                    return result;
                }
            }
        });
    }

    public static interface StringConstructor {
        public Object construct(String var1);
    }
}

