/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import com.pageseeder.publishapi.utils.XMLUtils;
import org.eclipse.jdt.annotation.Nullable;

public final class URIObject {
    private @Nullable String decodedpath = null;
    private @Nullable String path = null;
    private @Nullable String relativepath = null;
    private @Nullable String id = null;
    private @Nullable String labels = null;
    private @Nullable String docid = null;
    private @Nullable String title = null;
    private @Nullable String behavior = null;
    private @Nullable String format = null;
    private @Nullable String type = null;
    private final StringBuffer xrefs = new StringBuffer();
    private final StringBuffer reversexrefs = new StringBuffer();

    public @Nullable String getPath() {
        return this.path;
    }

    public boolean isFolder() {
        if ("folder".equals(this.type)) {
            return true;
        }
        String filepath = this.getPath();
        return this.type == null && filepath != null && filepath.endsWith("/");
    }

    public @Nullable String getDocid() {
        return this.docid;
    }

    public @Nullable String getFormat() {
        return this.format;
    }

    public @Nullable String getId() {
        return this.id;
    }

    public @Nullable String getLabels() {
        return this.labels;
    }

    public @Nullable String getRelativepath() {
        return this.relativepath;
    }

    public @Nullable String getDecodedPath() {
        return this.decodedpath;
    }

    public @Nullable String getTitle() {
        return this.title;
    }

    public @Nullable String getType() {
        return this.type;
    }

    public void setRelativepath(String relativepath) {
        this.relativepath = relativepath;
    }

    public void setDocid(String docid) {
        this.docid = docid;
    }

    public @Nullable String getBehavior() {
        return this.behavior;
    }

    public void setBehavior(@Nullable String behavior) {
        this.behavior = behavior;
        this.format = this.behavior == null || this.behavior.indexOf(45) == -1 ? null : this.behavior.substring(0, this.behavior.indexOf(45));
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDecodedpath(String dpath) {
        this.decodedpath = dpath;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void appendXRef(String xml) {
        this.xrefs.append(xml);
    }

    public void appendReverseXRef(String xml) {
        this.reversexrefs.append(xml);
    }

    public String toXML() {
        StringBuilder xml = new StringBuilder();
        this.toXML(xml);
        return xml.toString();
    }

    public void toXML(StringBuilder xml) {
        xml.append("<uri>");
        if (this.decodedpath != null) {
            xml.append("<decodedpath>").append(XMLUtils.escape(this.decodedpath)).append("</decodedpath>");
        }
        if (this.path != null) {
            xml.append("<path>").append(XMLUtils.escape(this.path)).append("</path>");
        }
        if (this.id != null) {
            xml.append("<id>").append(XMLUtils.escape(this.id)).append("</id>");
        }
        if (this.relativepath != null) {
            xml.append("<relativepath>").append(XMLUtils.escape(this.relativepath)).append("</relativepath>");
        }
        if (this.labels != null) {
            xml.append("<labels>").append(XMLUtils.escape(this.labels)).append("</labels>");
        }
        if (this.docid != null) {
            xml.append("<documentid>").append(XMLUtils.escape(this.docid)).append("</documentid>");
        }
        if (this.title != null) {
            xml.append("<usertitle>").append(XMLUtils.escape(this.title)).append("</usertitle>");
        }
        if (this.behavior != null) {
            xml.append("<behavior>").append(XMLUtils.escape(this.behavior)).append("</behavior>");
        }
        if (this.type != null) {
            xml.append("<type>").append(XMLUtils.escape(this.type)).append("</type>");
        }
        if (this.xrefs.length() > 0) {
            xml.append("<xrefs>").append(this.xrefs).append("</xrefs>");
        }
        if (this.reversexrefs.length() > 0) {
            xml.append("<reversexrefs>").append(this.reversexrefs).append("</reversexrefs>");
        }
        xml.append("</uri>");
    }
}

