/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import com.pageseeder.publishapi.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ResponseHandler
extends DefaultHandler {
    private final Deque<String> elements = new ArrayDeque<String>();
    private @Nullable String errorid = null;
    private final StringBuilder message = new StringBuilder();
    private final StringBuilder stacktrace = new StringBuilder();
    private final StringBuilder date = new StringBuilder();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.elements.isEmpty() && "error".equals(localName)) {
            this.errorid = attributes.getValue("id");
        }
        this.elements.push(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elements.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elements.isEmpty()) {
            return;
        }
        String parent = this.elements.pop();
        try {
            if (this.elements.isEmpty() || !"error".equals(this.elements.peek())) {
                return;
            }
            if ("message".equals(parent)) {
                this.message.append(ch, start, length);
            } else if ("stacktrace".equals(parent)) {
                this.stacktrace.append(ch, start, length);
            } else if ("date".equals(parent)) {
                this.date.append(ch, start, length);
            }
        }
        finally {
            this.elements.push(parent);
        }
    }

    public @Nullable String getErrorID() {
        return this.errorid;
    }

    public @Nullable String getDate() {
        return this.date.length() == 0 ? null : this.date.toString();
    }

    public @Nullable String getMessage() {
        return this.message.length() == 0 ? null : this.message.toString();
    }

    public @Nullable String getStacktrace() {
        return this.stacktrace.length() == 0 ? null : this.stacktrace.toString();
    }

    public static ResponseHandler readResponse(String response) throws IOException {
        ResponseHandler handler = new ResponseHandler();
        try {
            SAXParserFactory factory = XMLUtils.safeSAXParserFactory();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8))));
        }
        catch (ParserConfigurationException ex) {
            throw new IOException("Could not configure SAX parser.");
        }
        catch (SAXException ex) {
            throw new IOException("Error while parsing: " + ex.getMessage());
        }
        return handler;
    }
}

