/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.Request;
import com.pageseeder.publishapi.utils.URIObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class DownloadedItem {
    private final URIObject uri;
    private final Map<String, String> parameters;
    private final ExternalConfig config;

    public DownloadedItem(ExternalConfig config, URIObject uri, Map<String, String> params) {
        this.config = config;
        this.uri = uri;
        this.parameters = params;
    }

    public String getItempath() {
        return this.uri.getRelativepath() == null ? this.uri.getPath() : this.uri.getRelativepath();
    }

    public boolean isFolder() {
        return this.uri.isFolder();
    }

    public URIObject getURI() {
        return this.uri;
    }

    public void writeData(OutputStream out) throws PageseederException {
        if (this.isFolder()) {
            return;
        }
        Request request = new Request(this.uri.getPath(), this.config);
        for (Map.Entry<String, String> p : this.parameters.entrySet()) {
            request.addParameter(p.getKey(), p.getValue());
        }
        request.send();
        try (OutputStream outputStream = out;){
            out.write(request.getResponse());
        }
        catch (IOException ex) {
            throw new PageseederException("Failed to write response to output: " + ex.getMessage(), ex);
        }
    }

    public String toString() {
        return this.uri.getPath();
    }
}

