/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.oauth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OAuthUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthUtils.class);
    private static final Pattern JSON_STRING = Pattern.compile("\"([a-z_]+)\":\"([^\"]+)\"");
    private static final Pattern JSON_NUMBER = Pattern.compile("\"([a-z_]+)\":(\\d+)");

    private OAuthUtils() {
    }

    static Map<String, String> parse(String s) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        try (Scanner scanner = new Scanner(s);){
            scanner.useDelimiter("\\s*[{,}]\\s*");
            while (scanner.hasNext()) {
                if (scanner.hasNext(JSON_STRING)) {
                    scanner.next(JSON_STRING);
                    OAuthUtils.addToMap(scanner, map);
                    continue;
                }
                if (scanner.hasNext(JSON_NUMBER)) {
                    scanner.next(JSON_NUMBER);
                    OAuthUtils.addToMap(scanner, map);
                    continue;
                }
                String token = scanner.next();
                LOGGER.warn("Unable to parse JSON! Found unparsable token {}", (Object)token);
                break;
            }
        }
        return map;
    }

    private static void addToMap(Scanner scanner, Map<String, String> map) {
        MatchResult r = scanner.match();
        String name = r.group(1);
        String value = r.group(2);
        if (name != null && value != null) {
            map.put(name, value);
        }
    }

    static @Nullable Map<String, String> parseOpenIDToken(String idToken, byte[] key) {
        boolean isValidHeader;
        LOGGER.debug("Parsing JWT ID token");
        String[] segments = idToken.split("\\.");
        if (segments.length != 3) {
            LOGGER.error("Invalid ID Token: {} segments found", (Object)segments.length);
            return null;
        }
        Map<String, String> header = OAuthUtils.parse(OAuthUtils.decodeURLAsString(segments[0]));
        boolean bl = isValidHeader = "JWT".equals(header.get("typ")) && "HS256".equals(header.get("alg"));
        if (!isValidHeader) {
            LOGGER.error("Invalid ID token: unsupported JWT header");
            return null;
        }
        byte[] signature = OAuthUtils.decodeURLAsBytes(segments[2]);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            byte[] verify = mac.doFinal((segments[0] + "." + segments[1]).getBytes());
            if (!Arrays.equals(signature, verify)) {
                LOGGER.error("JWT token signature does not match");
                return null;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            return null;
        }
        try {
            Map<String, String> payload = OAuthUtils.parse(OAuthUtils.decodeURLAsString(segments[1]));
            String sub = payload.get("sub");
            if (sub != null) {
                Long id = Long.valueOf(sub);
                String username = payload.get("preferred_username");
                String firstname = payload.get("given_name");
                String surname = payload.get("family_name");
                String email = payload.get("email");
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("email", email);
                details.put("firstname", firstname);
                details.put("surname", surname);
                details.put("username", username);
                LOGGER.debug("Found member {} ({}) via Open ID", (Object)username, (Object)id);
                return details;
            }
            LOGGER.error("Invalid ID token: missing 'sub' in payload");
        }
        catch (Exception ex) {
            LOGGER.error("Invalid ID token: unable to parse payload", (Throwable)ex);
        }
        return null;
    }

    private static String decodeURLAsString(String toDecode) {
        return new String(OAuthUtils.decodeURLAsBytes(toDecode), StandardCharsets.UTF_8);
    }

    private static byte[] decodeURLAsBytes(String toDecode) {
        return Base64.getUrlDecoder().decode(toDecode.getBytes(StandardCharsets.UTF_8));
    }

    static String encodeParameters(Map<String, String> parameters) {
        StringBuilder q = new StringBuilder();
        for (Map.Entry<String, String> p : parameters.entrySet()) {
            if (q.length() > 0) {
                q.append("&");
            }
            q.append(URLEncoder.encode(p.getKey(), StandardCharsets.UTF_8));
            q.append("=").append(URLEncoder.encode(p.getValue(), StandardCharsets.UTF_8));
        }
        return q.toString();
    }

    static String readAll(InputStream in, int expectedLength) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int bufferSize = expectedLength > 1024 || expectedLength < 0 ? 1024 : expectedLength;
        byte[] buffer = new byte[bufferSize];
        while ((length = in.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8);
    }

    static InputStream stream(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode >= 200 && responseCode < 400) {
            InputStream in = connection.getInputStream();
            if (in == null) {
                throw new IllegalStateException("Unable to get connection output");
            }
            return in;
        }
        InputStream err = connection.getErrorStream();
        if (err == null) {
            throw new IllegalStateException("Unable to get connection output");
        }
        return err;
    }
}

