/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant.md;

import com.pageseeder.publishapi.ant.AntLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.md.BlockParser;
import org.pageseeder.psml.md.MarkdownInputOptions;
import org.pageseeder.psml.model.PSMLElement;
import org.pageseeder.psml.util.DiagnosticCollector;
import org.slf4j.Logger;

public class MarkdownImportTask
extends Task {
    private @Nullable String src;
    private @Nullable String dest;

    public void setSrc(String src) {
        this.src = src;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public void execute() throws BuildException {
        if (this.src == null || this.dest == null) {
            throw new BuildException("Both src and dest attributes are required");
        }
        try {
            PSMLElement psml;
            File input = new File(this.src);
            File output = new File(this.dest);
            output.getParentFile().mkdirs();
            Logger logger = AntLogger.newInstance(this);
            logger.info("Converting Markdown file: {} to PSML: {}", (Object)this.src, (Object)this.dest);
            try (BufferedReader in = new BufferedReader(new FileReader(input, StandardCharsets.UTF_8));){
                List lines = in.lines().collect(Collectors.toList());
                MarkdownInputOptions options = MarkdownInputOptions.defaultDocumentOptions().newFragmentPerHeading(true);
                BlockParser parser = new BlockParser(options);
                DiagnosticCollector collector = (isError, message) -> {
                    if (isError) {
                        logger.error(message);
                    } else {
                        logger.warn(message);
                    }
                };
                List elements = parser.parse(lines, collector);
                psml = new PSMLElement(PSMLElement.Name.DOCUMENT);
                psml.setAttribute("level", "portable");
                psml.addNodes(elements);
            }
            try (FileWriter out = new FileWriter(output, StandardCharsets.UTF_8);){
                out.write(psml.toString());
            }
        }
        catch (Exception e) {
            throw new BuildException("Error converting PSML to Markdown: " + e.getMessage(), (Throwable)e);
        }
    }
}

