/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ant.Parameter;
import com.pageseeder.publishapi.utils.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class RequestFileReader
extends DefaultHandler {
    private boolean inRequest = false;
    private @Nullable String paramName = null;
    private @Nullable String path = null;
    private @Nullable String method = null;
    private @Nullable String output = null;
    private @Nullable String body = null;
    private @Nullable List<Parameter> params = new ArrayList<Parameter>();
    private @Nullable XMLStringWriter xmlWriter = null;
    private @Nullable StringBuilder textWriter = null;
    private static @Nullable SAXParserFactory factory = null;

    private RequestFileReader() {
    }

    public @Nullable List<Parameter> getParams() {
        return this.params;
    }

    public @Nullable String getBody() {
        return this.body;
    }

    public @Nullable String getPath() {
        return this.path;
    }

    public @Nullable String getMethod() {
        return this.method;
    }

    public @Nullable String getOutput() {
        return this.output;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.xmlWriter != null) {
            this.xmlWriter.writeText(ch, start, length);
        } else if (this.textWriter != null) {
            this.textWriter.append(ch, start, length);
        }
    }

    @Override
    public void startElement(String nsURI, String localName, String qName, Attributes attributes) throws SAXException {
        String element;
        String string = element = localName == null || localName.isEmpty() ? qName : localName;
        if (this.xmlWriter != null) {
            this.xmlWriter.openElement(element);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attribute = attributes.getLocalName(i) == null ? attributes.getQName(i) : attributes.getLocalName(i);
                this.xmlWriter.attribute(attribute, attributes.getValue(i));
            }
        } else {
            if (this.textWriter != null) {
                throw new SAXException("Invalid request with body/parameter with XML content but text content type");
            }
            if ("request".equals(element)) {
                this.inRequest = true;
                this.path = attributes.getValue("path");
                this.method = attributes.getValue("method");
                this.output = attributes.getValue("output");
            } else if (this.inRequest && "servlet".equals(element) && this.path == null) {
                this.path = attributes.getValue("path");
            } else if (this.inRequest && "body".equals(element)) {
                String type = attributes.getValue("type");
                if ("xml".equals(type)) {
                    this.xmlWriter = new XMLStringWriter(XML.NamespaceAware.No);
                } else {
                    this.textWriter = new StringBuilder();
                }
            } else if (this.inRequest && "parameter".equals(element)) {
                this.paramName = attributes.getValue("name");
                String type = attributes.getValue("type");
                if ("xml".equals(type)) {
                    this.xmlWriter = new XMLStringWriter(XML.NamespaceAware.No);
                } else {
                    this.textWriter = new StringBuilder();
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String element;
        String string = element = localName == null || localName.isEmpty() ? qName : localName;
        if ("request".equals(element)) {
            this.inRequest = false;
        } else if ("body".equals(element) && this.xmlWriter != null) {
            this.body = this.xmlWriter.toString();
            this.xmlWriter = null;
        } else if ("body".equals(element) && this.textWriter != null) {
            this.body = this.textWriter.toString();
            this.textWriter = null;
        } else if ("parameter".equals(element) && (this.xmlWriter != null || this.textWriter != null)) {
            Parameter p = new Parameter();
            p.setName(this.paramName);
            p.setValue(this.xmlWriter != null ? this.xmlWriter.toString() : this.textWriter.toString());
            this.params.add(p);
            this.paramName = null;
            this.xmlWriter = null;
            this.textWriter = null;
        } else if (this.xmlWriter != null) {
            this.xmlWriter.closeElement();
        }
    }

    public static @Nullable RequestFileReader parse(File file) throws ParserConfigurationException, SAXException, IOException {
        if (factory == null) {
            RequestFileReader.initFactory();
        }
        if (file.exists()) {
            XMLReader reader = factory.newSAXParser().getXMLReader();
            RequestFileReader handler = new RequestFileReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(file.toURI().toString()));
            return handler;
        }
        return null;
    }

    private static void initFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory f = XMLUtils.safeSAXParserFactory();
        f.setValidating(false);
        f.setFeature("http://xml.org/sax/features/validation", false);
        factory = f;
    }
}

