/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class AntLogger
implements Logger {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static @Nullable Project defaultproject;
    private final String name;
    private final @Nullable Project project;

    public AntLogger(String name) {
        this.name = name;
        this.project = defaultproject;
    }

    private AntLogger(String name, Project project) {
        this.name = name;
        this.project = project;
    }

    public static void setProject(Project project) {
        defaultproject = project;
    }

    public static Logger newInstance(Task task) {
        return new AntLogger(task.getTaskName(), task.getProject());
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isDebugEnabled(Marker marker) {
        return true;
    }

    public void debug(String msg) {
        this.log(msg, 4, null, new Object[0]);
    }

    public void debug(String format, Object arg) {
        this.log(format, 4, null, arg);
    }

    public void debug(String format, Object ... argArray) {
        this.log(format, 4, null, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.log(msg, 4, t, new Object[0]);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.log(format, 4, null, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.log(format, 4, null, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.log(format, 4, null, arguments);
    }

    public void debug(Marker marker, String msg) {
        this.log(msg, 4, null, EMPTY_ARGS);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.log(msg, 4, t, EMPTY_ARGS);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(format, 4, null, arg1, arg2);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isInfoEnabled(Marker marker) {
        return true;
    }

    public void info(String msg) {
        this.log(msg, 2, null, new Object[0]);
    }

    public void info(String format, Object arg) {
        this.log(format, 2, null, arg);
    }

    public void info(String format, Object ... argArray) {
        this.log(format, 2, null, argArray);
    }

    public void info(Marker marker, String format, Object arg) {
        this.log(format, 2, null, arg);
    }

    public void info(String msg, Throwable t) {
        this.log(msg, 2, t, new Object[0]);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.log(format, 2, null, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.log(format, 2, null, arguments);
    }

    public void info(Marker marker, String msg) {
        this.log(msg, 2, null, EMPTY_ARGS);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.log(msg, 2, t, EMPTY_ARGS);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(format, 2, null, arg1, arg2);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    public void warn(String msg) {
        this.log(msg, 1, null, new Object[0]);
    }

    public void warn(String format, Object arg) {
        this.log(format, 1, null, arg);
    }

    public void warn(String format, Object ... argArray) {
        this.log(format, 1, null, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.log(msg, 1, t, new Object[0]);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.log(format, 1, null, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.log(format, 1, null, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.log(format, 1, null, arguments);
    }

    public void warn(Marker marker, String msg) {
        this.log(msg, 1, null, EMPTY_ARGS);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.log(msg, 1, t, EMPTY_ARGS);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(format, 1, null, arg1, arg2);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    public void error(String msg) {
        this.log(msg, 0, null, new Object[0]);
    }

    public void error(String format, Object arg) {
        this.log(format, 0, null, arg);
    }

    public void error(String format, Object ... argArray) {
        this.log(format, 0, null, argArray);
    }

    public void error(String msg, Throwable t) {
        this.log(msg, 0, t, new Object[0]);
    }

    public void error(Marker marker, String format, Object arg) {
        this.log(format, 0, null, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.log(format, 0, null, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.log(format, 0, null, arguments);
    }

    public void error(Marker marker, String msg) {
        this.log(msg, 0, null, EMPTY_ARGS);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.log(msg, 0, t, EMPTY_ARGS);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log(format, 0, null, arg1, arg2);
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isTraceEnabled(Marker marker) {
        return true;
    }

    public void trace(String msg) {
        this.log(msg, 3, null, new Object[0]);
    }

    public void trace(String format, Object arg) {
        this.log(format, 3, null, arg);
    }

    public void trace(String format, Object ... argArray) {
        this.log(format, 3, null, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.log(msg, 3, t, new Object[0]);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.log(format, 3, null, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.log(format, 3, null, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        this.log(format, 3, null, arguments);
    }

    public void trace(Marker marker, String msg) {
        this.log(msg, 3, null, EMPTY_ARGS);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.log(msg, 3, t, EMPTY_ARGS);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log(format, 3, null, arg1, arg2);
    }

    private void log(String message, int priority, @Nullable Throwable exception, Object ... args) {
        if (this.project == null) {
            return;
        }
        SLF4JBuildEvent buildEvent = new SLF4JBuildEvent(this.project, message, priority, exception, args);
        for (BuildListener buildListener : this.project.getBuildListeners()) {
            buildListener.messageLogged((BuildEvent)buildEvent);
        }
    }

    private static String format(String format, Object ... oArray) {
        StringBuilder message = new StringBuilder();
        int from = 0;
        int to = -1;
        for (Object o : oArray) {
            to = format.indexOf("{}", from);
            if (to < 0) break;
            message.append(format, from, to);
            message.append(o);
            from = to + 2;
        }
        message.append(format.substring(from));
        return message.toString();
    }

    private static class SLF4JBuildEvent
    extends BuildEvent {
        private static final long serialVersionUID = -5900281352326256031L;
        private final int priority;
        private final String format;
        private final Object[] args;
        private @Nullable String message;

        public SLF4JBuildEvent(Project project, String format, int priority, @Nullable Throwable exception, Object[] args) {
            super(project);
            if (exception != null) {
                this.setException(exception);
            }
            this.priority = priority;
            this.format = format;
            this.args = args;
        }

        public String getMessage() {
            if (this.message == null) {
                this.message = AntLogger.format(this.format, this.args);
            }
            return this.message;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

