/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.Request;
import com.pageseeder.publishapi.utils.ThreadResponseHandler;
import com.pageseeder.publishapi.utils.Utils;
import com.pageseeder.publishapi.utils.XMLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.ReaderInputStream;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Export {
    private static final int BUFFER_SIZE = 4096;
    private @Nullable Logger logger = null;
    private long pollingInterval = 0L;
    private @Nullable String src = null;
    private @Nullable String group = null;
    private @Nullable String dest = null;
    private @Nullable String srcuris = null;
    private @Nullable String context = null;
    private @Nullable String includes = null;
    private @Nullable String excludes = null;
    private boolean failOnError = true;
    private boolean metadataOnly = false;
    private boolean allUrls = false;
    private boolean interpublicationXrefs = false;
    private boolean independent = false;
    private boolean binaryMetadataOnly = false;
    private boolean loadImages = true;
    private boolean loadAlternate = true;
    private @Nullable String compareVersion = null;
    private @Nullable String releaseVersion = null;
    private @Nullable String publicationid = null;
    private int position = 1;
    private boolean processPublication = false;
    private @Nullable String ranges = null;
    private @Nullable String with = null;
    private @Nullable String without = null;
    private @Nullable String since = null;
    private boolean indexcomplete = false;
    private int forward = 0;
    private int reverse = 0;
    private @Nullable String xrefTypes = null;

    public void setCompare(@Nullable String compare) {
        this.compareVersion = compare;
    }

    public void setRelease(@Nullable String release) {
        this.releaseVersion = release;
    }

    public void setPublication(@Nullable String id, boolean process, int pos) {
        this.publicationid = id;
        this.processPublication = process;
        this.position = pos;
    }

    public void setLoadDetails(boolean images, boolean alternate) {
        this.loadImages = images;
        this.loadAlternate = alternate;
    }

    public void setXRefDepths(int fdepth, int rdepth) {
        this.forward = fdepth;
        this.reverse = rdepth;
    }

    public void setXRefTypes(@Nullable String types) {
        this.xrefTypes = types;
    }

    public void setFiltering(@Nullable String with, @Nullable String without, @Nullable String since, @Nullable String range, boolean wait) {
        this.with = with;
        this.without = without;
        this.since = since;
        this.ranges = range;
        this.indexcomplete = wait;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setContext(@Nullable String context) {
        this.context = context;
    }

    public void setDestination(@Nullable String destination) {
        this.dest = destination;
    }

    public void setIncludesExcludes(@Nullable String inc, @Nullable String exc) {
        this.includes = inc;
        this.excludes = exc;
    }

    public void setMetadataOnly(boolean metadataonly, boolean binarymetadataonly) {
        this.metadataOnly = metadataonly;
        this.binaryMetadataOnly = binarymetadataonly;
    }

    public void setAllUrls(boolean allurls) {
        this.allUrls = allurls;
    }

    public void setInterpublicationXrefs(boolean resolve) {
        this.interpublicationXrefs = resolve;
    }

    public void setIndependent(boolean ind) {
        this.independent = ind;
    }

    public void setSource(String source) {
        this.src = source;
    }

    public void setGroup(@Nullable String group) {
        this.group = group;
    }

    public void setSourceURIs(String srcURIs) {
        this.srcuris = srcURIs;
    }

    public void setPollingInterval(long interval) {
        this.pollingInterval = interval;
    }

    public void setLogger(Logger log) {
        this.logger = log;
    }

    public void export(ExternalConfig config) throws PageseederException {
        File output;
        boolean outputIsZip;
        if (this.src == null && this.srcuris == null && (this.context == null || this.group == null)) {
            throw new BuildException("One of src, srcuris or (context and group) must be specified");
        }
        if (this.src != null && this.srcuris != null) {
            throw new PageseederException("Only one of src or srcuris can be specified");
        }
        if (this.srcuris != null && this.context == null) {
            throw new PageseederException("Context must be specified if srcuris is used");
        }
        if (this.indexcomplete && this.group == null) {
            throw new PageseederException("Group must be specified if indexcomplete is used");
        }
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        if (this.indexcomplete && (this.with != null || this.without != null || this.since != null || this.ranges != null)) {
            Request req = new Request("/service/groups/" + this.group + "/index/status", config);
            req.send();
            IndexStatusHandler handler = IndexStatusHandler.parseResponse(req.getResponseAsString());
            while (!handler.isCompleted()) {
                this.logger.info("Waiting for indexing to complete as there are currently {} jobs in the queue.", (Object)handler.countJobs);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    throw new PageseederException("Cancelled export while checking index");
                }
                req = new Request("/service/groups/" + this.group + "/index/status", config);
                req.send();
                handler = IndexStatusHandler.parseResponse(req.getResponseAsString());
            }
        }
        if (outputIsZip = (output = new File(this.dest)).getName().toLowerCase().endsWith(".zip")) {
            if (output.exists()) {
                this.logger.warn("Output ZIP file {} will be overwritten", (Object)output.getAbsolutePath());
            } else {
                this.logger.debug("Output ZIP file is {}", (Object)output.getAbsolutePath());
            }
        } else {
            this.logger.info("Validating output folder {}", (Object)output.getAbsolutePath());
            if (output.exists() && !output.isDirectory()) {
                throw new PageseederException("Invalid output folder");
            }
            output.mkdirs();
            if (!output.exists()) {
                throw new PageseederException("Failed to create output folder");
            }
        }
        try {
            String xml;
            String username = config.getUsername();
            String groupPart = this.group != null ? "/groups/" + URLEncoder.encode(this.group, StandardCharsets.UTF_8) : "";
            String path = "/service/members/" + URLEncoder.encode(username, StandardCharsets.UTF_8).replace("+", "%20") + groupPart + "/export";
            this.logger.info("Building request to {}", (Object)path);
            Request request = new Request(path, config);
            request.setHTTPMethod("POST");
            if (this.pollingInterval > 0L) {
                request.setThreadHandlingDetails(this.pollingInterval, null);
            }
            if (this.srcuris != null) {
                request.addParameter("uris", this.srcuris);
                this.logger.debug("Using param uris: {}", (Object)this.srcuris);
            } else {
                request.addParameter("path", this.src);
                String host = config.getUriHost() == null ? config.getHost() : config.getUriHost();
                request.addParameter("host", host);
                this.logger.debug("Using params host, path: {}, {}", (Object)host, (Object)this.src);
            }
            if (this.context != null) {
                request.addParameter("context", this.context);
                this.logger.debug("context param is {}", (Object)this.context);
            }
            request.addParameter("metadata-only", String.valueOf(this.metadataOnly));
            this.logger.debug("metadata-only param is {}", (Object)this.metadataOnly);
            request.addParameter("allurls", String.valueOf(this.allUrls));
            this.logger.debug("allurls param is {}", (Object)this.allUrls);
            request.addParameter("interpublication-xrefs", String.valueOf(this.interpublicationXrefs));
            this.logger.debug("interpublication-xrefs param is {}", (Object)this.interpublicationXrefs);
            request.addParameter("independent", String.valueOf(this.independent));
            this.logger.debug("independent param is {}", (Object)this.independent);
            request.addParameter("binary-metadata-only", String.valueOf(this.binaryMetadataOnly));
            this.logger.debug("binary-metadata-only param is {}", (Object)this.binaryMetadataOnly);
            request.addParameter("load-images", String.valueOf(this.loadImages));
            this.logger.debug("load-images param is {}", (Object)this.loadImages);
            request.addParameter("load-alternates", String.valueOf(this.loadAlternate));
            this.logger.debug("load-alternates param is {}", (Object)this.loadAlternate);
            if (this.excludes != null) {
                request.addParameter("excludes", this.excludes);
                this.logger.debug("excludes param is {}", (Object)this.excludes);
            }
            if (this.includes != null) {
                request.addParameter("includes", this.includes);
                this.logger.debug("includes param is {}", (Object)this.includes);
            }
            if (this.forward != 0) {
                request.addParameter("forward-depth", String.valueOf(this.forward));
                this.logger.debug("forward-depth param is {}", (Object)this.forward);
            }
            if (this.reverse != 0) {
                request.addParameter("reverse-depth", String.valueOf(this.reverse));
                this.logger.debug("reverse-depth param is {}", (Object)this.reverse);
            }
            if (this.xrefTypes != null) {
                request.addParameter("xref-types", this.xrefTypes);
                this.logger.debug("xref-types param is {}", (Object)this.xrefTypes);
            }
            if (this.with != null) {
                request.addParameter("with", this.with);
                this.logger.debug("with param is {}", (Object)this.with);
            }
            if (this.without != null) {
                request.addParameter("without", this.without);
                this.logger.debug("without param is {}", (Object)this.without);
            }
            if (this.since != null) {
                request.addParameter("since", this.since);
                this.logger.debug("since param is {}", (Object)this.since);
            }
            if (this.ranges != null) {
                request.addParameter("ranges", this.ranges);
                this.logger.debug("ranges param is {}", (Object)this.ranges);
            }
            if (this.releaseVersion != null) {
                request.addParameter("release", this.releaseVersion);
                this.logger.debug("release param is {}", (Object)this.releaseVersion);
            }
            if (this.compareVersion != null) {
                request.addParameter("compare", this.compareVersion);
                this.logger.debug("compare param is {}", (Object)this.compareVersion);
            }
            if (this.publicationid != null) {
                request.addParameter("publicationid", this.publicationid);
                this.logger.debug("publicationid param is {}", (Object)this.publicationid);
            }
            request.addParameter("process-publication", String.valueOf(this.processPublication));
            this.logger.debug("process-publication param is {}", (Object)this.processPublication);
            request.addParameter("position", String.valueOf(this.position));
            this.logger.debug("position param is {}", (Object)this.position);
            request.addParameter("fail-on-error", String.valueOf(this.failOnError));
            this.logger.debug("fail-on-error param is {}", (Object)this.failOnError);
            this.logger.debug("Sending request");
            request.send();
            this.logger.debug("Getting response");
            try {
                xml = request.getResponseAsString();
            }
            catch (PageseederException ex) {
                String msg;
                ThreadResponseHandler handler = this.parseThreadResponse(ex.getResponse());
                if (handler.getThreadID() != null) {
                    this.logger.error("<threadid>{}</threadid>", (Object)handler.getThreadID());
                }
                throw new PageseederException((String)((msg = handler.getThreadMessage()).isEmpty() ? "connection failed, HTTP code was " + ex.getHttpStatus() : msg));
            }
            this.logger.debug("Parsing response");
            ThreadResponseHandler handler = this.parseThreadResponse(xml);
            String zipFileName = handler.getZipFileName();
            if (zipFileName.isEmpty()) {
                String error;
                if (handler.getThreadID() != null) {
                    this.logger.error("<threadid>{}</threadid>", (Object)handler.getThreadID());
                }
                if ((error = handler.getThreadMessage()).isEmpty()) {
                    error = "Failed to extract ZIP filename from Pageseeder response";
                }
                this.logger.debug("Thread response was {}", (Object)xml);
                PageseederException ex = new PageseederException(error);
                ex.setResponse(xml);
                throw ex;
            }
            this.logger.info("Found zip to download: {}", (Object)zipFileName);
            path = "/member-resource/" + handler.getGroupID() + "/" + zipFileName;
            Request zipRequest = new Request(path, config);
            this.logger.debug("Building binary request to {}", (Object)path);
            zipRequest.send();
            this.logger.debug("Binary request sent");
            File zipFile = outputIsZip ? output : new File(output, zipFileName);
            this.logger.debug("Saving ZIP as {}", (Object)zipFile.getAbsolutePath());
            if (!zipFile.createNewFile()) {
                throw new PageseederException("Failed to create output ZIP file " + zipFile.getAbsolutePath());
            }
            try (FileOutputStream fos = new FileOutputStream(zipFile);){
                zipRequest.getResponse(fos);
            }
            if (outputIsZip) {
                this.logger.info("ZIP saved!");
            } else {
                this.logger.info("ZIP saved, unzipping now");
                ZipFile zipObject = new ZipFile(zipFile);
                Enumeration<? extends ZipEntry> entries = zipObject.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory()) {
                        File dir = Utils.descendantFile(output, name);
                        dir.mkdirs();
                        continue;
                    }
                    File file = Utils.descendantFile(output, name);
                    if (name.indexOf(47) != -1) {
                        File dir = file.getParentFile();
                        dir.mkdirs();
                    }
                    this.logger.debug("Unzipping file {}", (Object)file.getAbsolutePath());
                    this.saveFile(file, zipObject.getInputStream(entry));
                }
                this.logger.info("Unzipping completed");
                zipObject.close();
                if (!zipFile.delete()) {
                    this.logger.error("Unable to delete zip file");
                }
            }
        }
        catch (IOException e) {
            throw new PageseederException("Failed to save downloaded files: " + e.getMessage(), e);
        }
    }

    private ThreadResponseHandler parseThreadResponse(String xml) {
        ThreadResponseHandler handler = new ThreadResponseHandler(true);
        try {
            XMLUtils.parse((InputStream)new ReaderInputStream((Reader)new StringReader(xml)), handler);
        }
        catch (PageseederException ex) {
            this.logger.error("Failed to parse PS thread response: {}", (Object)ex.getMessage());
        }
        return handler;
    }

    private void saveFile(File file, InputStream in) throws IOException {
        try (InputStream inputStream = in;
             FileOutputStream fos = new FileOutputStream(file);){
            int read;
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
            }
        }
    }

    private static class IndexStatusHandler
    extends DefaultHandler {
        private int countJobs = 0;

        private IndexStatusHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("jobs".equals(localName) || "jobs".equals(qName)) {
                String count = attributes.getValue("total");
                this.countJobs = Integer.parseInt(count);
            }
        }

        public boolean isCompleted() {
            return this.countJobs == 0;
        }

        public static IndexStatusHandler parseResponse(String xml) throws PageseederException {
            IndexStatusHandler handler = new IndexStatusHandler();
            XMLUtils.parse((InputStream)new ReaderInputStream((Reader)new StringReader(xml)), handler);
            return handler;
        }
    }
}

