/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.anthropic.model;

import java.io.IOException;
import net.pageseeder.ai.anthropic.model.ErrorResponse;
import net.pageseeder.ai.anthropic.model.SuccessfulResponse;
import org.eclipse.jdt.annotation.Nullable;

public final class Response<T extends SuccessfulResponse> {
    private final int httpCode;
    private final @Nullable T success;
    private final @Nullable ErrorResponse error;

    public Response(int httpCode, T success) {
        this.httpCode = httpCode;
        this.success = success;
        this.error = null;
    }

    private Response(int httpCode, ErrorResponse error) {
        this.httpCode = httpCode;
        this.success = null;
        this.error = error;
    }

    public static <T extends SuccessfulResponse> Response<T> error(int httpCode, ErrorResponse error) {
        return new Response<T>(httpCode, error);
    }

    public @Nullable T get() {
        return this.success;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public @Nullable ErrorResponse getError() {
        return this.error;
    }

    public boolean hasResponse() {
        return this.success != null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void print(Appendable appendable) throws IOException {
        if (this.success != null) {
            appendable.append(this.success.toString());
        } else if (this.error != null) {
            appendable.append(this.error.toString());
        }
    }
}

