/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.anthropic;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.pageseeder.ai.anthropic.ClaudeContent;
import net.pageseeder.ai.anthropic.ClaudeMessage;
import net.pageseeder.ai.anthropic.ClaudeModel;
import net.pageseeder.ai.util.SHA256;
import org.eclipse.jdt.annotation.Nullable;

public final class ClaudeRequest {
    private ClaudeModel model = ClaudeModel.CLAUDE_4_5_SONNET_20250929;
    private int maxTokens = 1000;
    private @Nullable String userId;
    private double temperature = 0.0;
    private @Nullable String system = null;
    private final List<ClaudeMessage> userMessages = new ArrayList<ClaudeMessage>();

    public ClaudeRequest() {
    }

    public ClaudeRequest(String user) {
        this.userMessages.add(new ClaudeMessage(user));
    }

    public ClaudeRequest(String user, int maxTokens) {
        this.maxTokens = maxTokens;
        this.userMessages.add(new ClaudeMessage(user));
    }

    public void setMaxTokens(int maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setModel(ClaudeModel model) {
        this.model = model;
    }

    public void setSystem(@Nullable String system) {
        this.system = system;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void addUserMessage(String text) {
        if (this.userMessages.isEmpty()) {
            this.userMessages.add(new ClaudeMessage(text));
        } else {
            this.userMessages.get(this.userMessages.size() - 1).addContent(text);
        }
    }

    public void addUserMessage(byte[] bytes, String mediatype) {
        if (this.userMessages.isEmpty()) {
            ClaudeMessage message = new ClaudeMessage(ClaudeMessage.Role.USER);
            message.addContent(bytes, mediatype);
            this.userMessages.add(message);
        } else {
            this.userMessages.get(this.userMessages.size() - 1).addContent(bytes, mediatype);
        }
    }

    public ClaudeModel getModel() {
        return this.model;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public @Nullable String getSystem() {
        return this.system;
    }

    public List<ClaudeMessage> getUserMessages() {
        return this.userMessages;
    }

    public @Nullable String getUserId() {
        return this.userId;
    }

    public String toJson() {
        JsonFactory factory = new JsonFactory();
        StringWriter out = new StringWriter();
        try (JsonGenerator json = factory.createGenerator((Writer)out);){
            json.writeStartObject();
            json.writeStringField("model", this.model.toString());
            if (this.maxTokens > 0) {
                json.writeNumberField("max_tokens", this.maxTokens);
            }
            if (this.system != null) {
                json.writeStringField("system", this.system);
            }
            if (this.temperature > 0.0) {
                json.writeNumberField("temperature", this.temperature);
            }
            json.writeArrayFieldStart("messages");
            for (ClaudeMessage m : this.userMessages) {
                ClaudeRequest.toJsonMessage(m, json);
            }
            json.writeEndArray();
            if (this.userId != null) {
                json.writeObjectFieldStart("metadata");
                json.writeStringField("user_id", this.userId);
                json.writeEndObject();
            }
            json.writeEndObject();
            json.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return out.toString();
    }

    private static void toJsonMessage(ClaudeMessage m, JsonGenerator json) throws IOException {
        json.writeStartObject();
        json.writeStringField("role", m.getRoleAsString());
        List<ClaudeContent> contents = m.getContents();
        if (contents.size() == 1 && contents.get(0).getType() == ClaudeContent.Type.TEXT) {
            json.writeStringField("content", contents.get(0).getText());
        } else {
            json.writeArrayFieldStart("content");
            for (ClaudeContent c : contents) {
                json.writeStartObject();
                json.writeStringField("type", c.getTypeAsString());
                if (c.getType() == ClaudeContent.Type.TEXT) {
                    json.writeStringField("text", c.getText());
                } else if (c.getType() == ClaudeContent.Type.IMAGE || c.getType() == ClaudeContent.Type.DOCUMENT) {
                    json.writeObjectFieldStart("source");
                    json.writeStringField("type", "base64");
                    json.writeStringField("media_type", c.getMediaType());
                    json.writeStringField("data", c.getBytesAsBase64());
                    json.writeEndObject();
                }
                if (c.isCacheControlEnabled()) {
                    json.writeStringField("cache_control", "ephemeral");
                }
                json.writeEndObject();
            }
            json.writeEndArray();
        }
        json.writeEndObject();
    }

    public String getHash() {
        StringBuilder buffer = new StringBuilder(this.maxTokens + "|" + String.valueOf((Object)this.model) + "||" + this.temperature);
        for (ClaudeMessage m : this.userMessages) {
            buffer.append('|').append((Object)m.getRole());
            for (ClaudeContent c : m.getContents()) {
                buffer.append(':').append(c.getContentAsString());
            }
        }
        return SHA256.hash(buffer.toString());
    }
}

