/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.anthropic;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.pageseeder.ai.anthropic.ClaudeContent;

public final class ClaudeMessage {
    private final Role role;
    private final List<ClaudeContent> content = new ArrayList<ClaudeContent>();

    public ClaudeMessage(Role role, String text) {
        this.role = Objects.requireNonNull(role);
        this.content.add(new ClaudeContent(text));
    }

    public ClaudeMessage(Role role) {
        this.role = Objects.requireNonNull(role);
    }

    public ClaudeMessage(String text) {
        this(Role.USER, text);
    }

    public ClaudeMessage() {
        this.role = Role.USER;
    }

    public void addContent(String text) {
        this.content.add(new ClaudeContent(text));
    }

    public void addContent(byte[] bytes, String mediatype) {
        this.content.add(new ClaudeContent(bytes, mediatype));
    }

    public Role getRole() {
        return this.role;
    }

    public String getRoleAsString() {
        return this.role.toString().toLowerCase();
    }

    public List<ClaudeContent> getContents() {
        return this.content;
    }

    public static enum Role {
        ASSISTANT,
        USER;

    }
}

