/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith.rule;

import java.io.IOException;
import java.util.Map;
import org.pageseeder.smith.PasswordRule;
import org.pageseeder.smith.ScoreFunction;
import org.pageseeder.smith.Scriptable;
import org.pageseeder.smith.function.LinearScore;
import org.pageseeder.smith.function.ScoreArray;

public final class SpecialCharCountRule
implements PasswordRule,
Scriptable {
    public static final String DEFAULT_CHARS = "!@#$%^&*?_~";
    private ScoreFunction _function = LinearScore.IDENTITY;
    private String _chars;

    public SpecialCharCountRule() {
        this._chars = DEFAULT_CHARS;
    }

    public SpecialCharCountRule(String chars) {
        this._chars = chars;
    }

    @Override
    public int score(String password) {
        if (password == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (this._chars.indexOf(c) < 0) continue;
            ++count;
        }
        return this._function.get(count);
    }

    @Override
    public void configure(Map<String, String> config) {
        String chars = config.get("characters");
        if (chars != null) {
            this._chars = chars;
        }
        this._function = ScoreArray.parse(config);
    }

    @Override
    public Appendable toScript(Appendable script) throws IOException {
        script.append("function (p) {");
        script.append(" var f = ");
        this._function.toScript(script).append(";");
        StringBuilder regexp = new StringBuilder();
        for (int i = 0; i < this._chars.length(); ++i) {
            regexp.append('\\').append(this._chars.charAt(i));
        }
        script.append(" var s = p? p.length - p.replace(/[" + regexp + "]/g, '').length : 0;");
        script.append(" return f(s);");
        script.append("}");
        return script;
    }
}

