/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith.rule;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pageseeder.smith.PasswordRule;
import org.pageseeder.smith.Scriptable;

public class BannedPasswordRule
implements PasswordRule,
Scriptable {
    private Set<String> _banned = null;
    private int forBanned = -100;
    private int forAllowed = 0;

    @Override
    public int score(String password) {
        if (this._banned == null) {
            this._banned = BannedPasswordRule.load();
        }
        if (this._banned.contains(password)) {
            return this.forBanned;
        }
        return this.forAllowed;
    }

    @Override
    public void configure(Map<String, String> config) {
        Set<String> banned = null;
        String file = config.get("file");
        if (file != null && !"#default".equals(file)) {
            try {
                banned = BannedPasswordRule.load(new FileReader(file));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        } else {
            BannedPasswordRule.load();
        }
        String list = config.get("list");
        if (list != null) {
            String[] words = list.split(",");
            if (banned == null) {
                banned = new HashSet<String>();
            }
            for (String word : words) {
                banned.add(word);
            }
        }
        this._banned = banned;
    }

    public static Set<String> load() {
        ClassLoader loader = BannedPasswordRule.class.getClassLoader();
        InputStream in = null;
        HashSet<String> banned = new HashSet();
        try {
            in = loader.getResourceAsStream("org/pageseeder/smith/rule/banned.txt");
            InputStreamReader r = new InputStreamReader(in);
            banned = BannedPasswordRule.load(r);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return banned;
    }

    public static Set<String> load(Reader reader) throws IOException {
        BufferedReader buffered = null;
        HashSet<String> banned = new HashSet<String>();
        try {
            buffered = new BufferedReader(reader);
            String word = buffered.readLine();
            while (word != null) {
                banned.add(word);
                word = buffered.readLine();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            try {
                if (buffered != null) {
                    buffered.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return banned;
    }

    @Override
    public Appendable toScript(Appendable script) throws IOException {
        if (this._banned == null) {
            this._banned = BannedPasswordRule.load();
        }
        script.append("function (p) {");
        script.append(" var b = [");
        Iterator<String> words = this._banned.iterator();
        while (words.hasNext()) {
            String word = words.next();
            script.append("'" + word.replaceAll("'", "\\'") + "'");
            if (!words.hasNext()) continue;
            script.append(',');
        }
        script.append("];");
        script.append(" for (var i = 0; i < b.length; i++) {");
        script.append("   if (b[i] === p) { return " + this.forBanned + "; }");
        script.append(" }");
        script.append("return " + this.forAllowed + ";");
        script.append("}");
        return script;
    }
}

