/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith.function;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.pageseeder.smith.ScoreFunction;
import org.pageseeder.smith.Scriptable;
import org.pageseeder.smith.function.ScoreFunctionBase;

public final class ScoreArray
extends ScoreFunctionBase
implements ScoreFunction,
Scriptable {
    public static final int MAX_ARRAY_SIZE = 1024;
    private final int[] _scores;

    public ScoreArray() {
        super("array");
        this._scores = new int[0];
    }

    public ScoreArray(int[] scores) {
        super("array");
        this._scores = scores;
    }

    @Override
    public int get(int i) {
        if (i < 0 || this._scores.length == 0) {
            return 0;
        }
        if (i < this._scores.length) {
            return this._scores[i];
        }
        return this._scores[this._scores.length - 1];
    }

    protected int[] scores() {
        return Arrays.copyOf(this._scores, this._scores.length);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append('[');
        for (int i = 0; i < this._scores.length; ++i) {
            if (i > 0) {
                out.append(',');
            }
            out.append(this._scores[i]);
        }
        out.append(']');
        return out.toString();
    }

    public static ScoreArray parse(Map<String, String> config) {
        TreeMap<Integer, Integer> sorted = new TreeMap<Integer, Integer>();
        for (Map.Entry<String, String> e : config.entrySet()) {
            Integer v;
            Integer i = ScoreArray.asInteger(e.getKey());
            if (i == null || i <= 0 || i >= 1024 || (v = ScoreArray.asInteger(e.getValue())) == null) continue;
            sorted.put(i, v);
        }
        if (sorted.size() == 0) {
            return new ScoreArray(new int[0]);
        }
        int size = (Integer)sorted.lastKey() + 1;
        int[] scores = new int[size];
        int score = 0;
        for (int i = 0; i < size; ++i) {
            Integer x = (Integer)sorted.get(i);
            if (x != null) {
                score = x;
            }
            scores[i] = score;
        }
        return new ScoreArray(scores);
    }

    protected static ScoreArray linearRange(int from, int to) {
        int[] scores = new int[to + 1];
        int i = from;
        int j = 0;
        while (i < to + 1) {
            scores[i] = j + 1;
            ++i;
            ++j;
        }
        return new ScoreArray(scores);
    }

    private static Integer asInteger(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || i <= 0 && c == '-') continue;
            return null;
        }
        return Integer.valueOf(s);
    }

    @Override
    public Appendable toScript(Appendable script) throws IOException {
        script.append("function (i) {");
        script.append(" var x = [");
        for (int i = 0; i < this._scores.length; ++i) {
            if (i > 0) {
                script.append(',');
            }
            script.append(Integer.toString(this._scores[i]));
        }
        script.append("];");
        script.append(" if (i < 0 || x.length === 0) return 0;");
        script.append(" if (i < x.length) return x[i];");
        script.append(" return x[x.length -1];");
        script.append("}");
        return script;
    }
}

