/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.queries;

import com.pageseeder.common.util.GenericBuilder;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.queries.Ranges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.lucene.query.AnyTermParameter;
import org.pageseeder.flint.lucene.query.FacetParameter;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.query.Question;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.search.Facet;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericQuery
implements SearchQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericQuery.class);
    private final Question question;
    private final AnyTermParameter types;
    private final List<FacetParameter> facets;
    private final List<Ranges.Range<?>> ranges;
    private final Sort sort;
    private final @Nullable Query query;

    private GenericQuery(Question question, AnyTermParameter types, List<FacetParameter> facets, List<Ranges.Range<?>> ranges, Sort sort) {
        this.question = Objects.requireNonNull(question, "The question is required");
        this.types = Objects.requireNonNull(types, "The types are required");
        this.facets = Objects.requireNonNull(facets, "The facets required");
        this.sort = Objects.requireNonNull(sort, "The sort is required");
        this.ranges = ranges;
        this.query = GenericQuery.toQuery(question, types, facets, ranges);
    }

    public Question question() {
        return this.question;
    }

    public Sort getSort() {
        return this.sort;
    }

    public boolean isEmpty() {
        return this.query == null;
    }

    public @Nullable Query toQuery() {
        return this.query;
    }

    public GenericQuery newGenericQuery(Question question) {
        return new GenericQuery(question, this.types, this.facets, this.ranges, this.sort);
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("generic-query", true);
        xml.attribute("empty", Boolean.toString(this.isEmpty()));
        if (!this.isEmpty()) {
            xml.attribute("query", this.query.toString());
            if (this.question != null) {
                this.question.toXML(xml);
            }
            if (this.types != null) {
                this.types.toXML(xml);
            }
            for (FacetParameter f : this.facets) {
                f.toXML(xml);
            }
            Ranges.toXML(this.ranges, xml);
            xml.openElement("sort", this.sort != Sort.RELEVANCE);
            if (this.sort == Sort.RELEVANCE) {
                xml.attribute("by", "relevance");
            } else {
                xml.attribute("by", "fields");
                for (SortField sf : this.sort.getSort()) {
                    xml.openElement("sortfield");
                    xml.attribute("field", sf.getField());
                    xml.attribute("type", sf.getType().name());
                    xml.attribute("reverse", Boolean.toString(sf.getReverse()));
                    xml.closeElement();
                }
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    private static @Nullable Query toQuery(Question question, AnyTermParameter types, List<FacetParameter> facets, List<Ranges.Range<?>> ranges) {
        Query query = null;
        if (!question.isEmpty()) {
            query = question.toQuery();
        }
        if (!types.isEmpty()) {
            Query hasType = types.toQuery();
            Query query2 = query = query != null ? Queries.and((Query[])new Query[]{query, hasType}) : hasType;
        }
        if (!facets.isEmpty() || ranges != null && !ranges.isEmpty()) {
            BooleanQuery.Builder fq = new BooleanQuery.Builder();
            for (FacetParameter facetParameter : facets) {
                fq.add(facetParameter.toQuery(), BooleanClause.Occur.MUST);
            }
            if (ranges != null && !ranges.isEmpty()) {
                for (Ranges.Range range : ranges) {
                    fq.add(range.toParameter().toQuery(), BooleanClause.Occur.MUST);
                }
            }
            query = query != null ? Queries.and((Query[])new Query[]{query, fq.build()}) : fq.build();
        }
        return query;
    }

    public static final class Builder
    implements GenericBuilder<GenericQuery> {
        static final String TYPE_FIELD = "pstype";
        public static final String LASTMODIFIED_FIELD = "psmodifieddate";
        static final String SIZE_FIELD = "pssize";
        private @Nullable String question = null;
        private final List<Ranges.Range<?>> ranges = new ArrayList();
        private final List<Term> types = new ArrayList<Term>();
        private final List<String> fields = new ArrayList<String>();
        private @Nullable List<FacetParameter> facets = null;
        private @Nullable Group group;
        private Database db;
        private @Nullable List<SortField> sort = null;
        private @Nullable Date from = null;
        private @Nullable Date to = null;
        private @Nullable Integer minSize = null;
        private @Nullable Integer maxSize = null;

        public Builder question(String question) {
            this.question = question;
            return this;
        }

        public Builder addRange(@Nullable Ranges.Range<?> range) {
            if (range != null) {
                this.ranges.add(range);
            }
            return this;
        }

        public Builder addType(@Nullable String type) {
            if (type != null && !type.isEmpty()) {
                Term t = new Term(TYPE_FIELD, type);
                this.types.add(t);
            } else {
                LOGGER.info("Attempted to add empty type - ignored");
            }
            return this;
        }

        public Builder from(Date from) {
            this.from = from;
            return this;
        }

        public Builder to(Date to) {
            this.to = to;
            return this;
        }

        public Builder minSize(Integer min) {
            this.minSize = min;
            return this;
        }

        public Builder maxSize(Integer max) {
            this.maxSize = max;
            return this;
        }

        public Builder addSetSortField(String field, boolean reverse) {
            if (Fields.isValidName((String)field)) {
                if (this.sort == null) {
                    this.sort = new ArrayList<SortField>();
                }
                this.sort.add((SortField)new SortedSetSortField(field, reverse));
            }
            return this;
        }

        public Builder addSortField(String field, SortField.Type type, boolean reverse) {
            if (Fields.isValidName((String)field)) {
                if (this.sort == null) {
                    this.sort = new ArrayList<SortField>();
                }
                this.sort.add(new SortField(field, type, reverse));
            }
            return this;
        }

        public Builder addNumericSortField(String field, SortField.Type type, boolean reverse) {
            if (Fields.isValidName((String)field)) {
                if (this.sort == null) {
                    this.sort = new ArrayList<SortField>();
                }
                this.sort.add((SortField)new SortedNumericSortField(field, type, reverse));
            }
            return this;
        }

        public Builder addSearchField(String field) {
            this.fields.add(field);
            return this;
        }

        public Builder addFieldFacet(Facet facet, String value) {
            FacetParameter fp;
            if (this.facets == null) {
                this.facets = new ArrayList<FacetParameter>();
            }
            if (!(fp = new FacetParameter(facet, value)).isEmpty()) {
                this.facets.add(fp);
            }
            return this;
        }

        public void resetFieldFacets() {
            if (this.facets != null) {
                this.facets.clear();
            }
        }

        public Builder group(Group group) {
            this.group = group;
            return this;
        }

        public Builder database(Database db) {
            this.db = db;
            return this;
        }

        public GenericQuery build() {
            IndexMaster master = IndexMaster.getInstance();
            String q = this.question != null ? this.question : "";
            LOGGER.debug("Parsing question: {}", (Object)q);
            Question question = master.newQuestion(this.db, this.group, this.fields, q);
            AnyTermParameter types = !this.types.isEmpty() ? new AnyTermParameter(this.types) : AnyTermParameter.empty();
            List<Object> facets = this.facets != null && !this.facets.isEmpty() ? Collections.unmodifiableList(new ArrayList<FacetParameter>(this.facets)) : Collections.emptyList();
            Sort sort = Sort.RELEVANCE;
            if (this.sort != null && !this.sort.isEmpty()) {
                sort = new Sort(this.sort.toArray(new SortField[this.sort.size()]));
            }
            if (this.from != null || this.to != null) {
                this.ranges.add(new Ranges.DateRange(LASTMODIFIED_FIELD, this.from, this.to, true, true, false, DateTools.Resolution.MINUTE));
                this.from = null;
                this.to = null;
            }
            if (this.minSize != null || this.maxSize != null) {
                this.ranges.add(new Ranges.NumberRange(SIZE_FIELD, this.minSize, this.maxSize, true, true));
                this.minSize = null;
                this.maxSize = null;
            }
            List<Ranges.Range<?>> ranges = this.ranges != null && !this.ranges.isEmpty() ? Collections.unmodifiableList(new ArrayList(this.ranges)) : Collections.emptyList();
            return new GenericQuery(question, types, facets, ranges, sort);
        }
    }
}

