/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.search.flint.DeleteRules;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.content.DeleteRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XLinkContent
implements Content {
    private static final Logger LOGGER = LoggerFactory.getLogger(XLinkContent.class);
    private final Long id;
    private final boolean asTask;
    private @Nullable Long deleteID = null;
    private boolean resolved = false;
    private boolean deleted = false;
    private @Nullable String mediatype = null;
    private @Nullable Long groupID = null;
    private byte @Nullable [] content = null;
    private @Nullable String publicationsAsXML = null;

    public XLinkContent(Long id, Long groupID, boolean asTask) {
        this.id = id;
        this.asTask = asTask;
        this.groupID = groupID;
    }

    public static XLinkContent deleteXLinkContent(Long id, boolean asTask) {
        return new XLinkContent(id, asTask);
    }

    private XLinkContent(Long id, boolean asTask) {
        this.id = id;
        this.asTask = asTask;
        this.deleted = true;
        this.groupID = null;
    }

    public ContentType getContentType() {
        return PSContentType.COMMENT;
    }

    public @Nullable String getPublicationsXML() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.publicationsAsXML;
    }

    public String getContentID() {
        return this.id.toString();
    }

    public @Nullable InputStream getSource() {
        if (!this.resolved) {
            this.resolve();
        }
        if (this.isDeleted()) {
            return null;
        }
        return new ByteArrayInputStream(this.content);
    }

    public @Nullable File getFile() {
        return null;
    }

    public @Nullable String getMediaType() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.mediatype;
    }

    public boolean isDeleted() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.deleted;
    }

    public DeleteRule getDeleteRule() {
        return this.asTask ? DeleteRules.newTaskDeleteRule(this.deleteID) : DeleteRules.newCommentDeleteRule(this.deleteID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.resolved) {
            return;
        }
        try {
            Database db = Database.open();
            Transaction tr = null;
            try {
                Locator loc;
                tr = new Transaction(db);
                tr.begin();
                XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)this.id);
                XLink taskRoot = xl != null && this.asTask ? XLinks.getThreadRoot((XLink)xl) : null;
                Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.groupID);
                boolean deleteRequested = this.deleted;
                if (!this.deleted) {
                    boolean bl = this.deleted = xl == null;
                }
                if (!this.deleted) {
                    this.deleted = !XLinkRule.belongsToGroup((XLink)(taskRoot != null ? taskRoot : xl), (Group)group);
                }
                try (UniversalPrinter xml = UniversalPrinter.newWriter((OutputType)OutputType.XML);){
                    if (this.asTask) {
                        this.mediatype = "application/vnd.pageseeder.task+xml";
                        if (!this.deleted && !XLinkRule.isTask((XLink)xl)) {
                            this.deleted = true;
                        }
                        Long l = this.deleteID = taskRoot == null || deleteRequested ? this.id : taskRoot.getId();
                        if (!this.deleted) {
                            Discussion task = new Discussion(taskRoot, Collections.singleton(group.getName()));
                            task.loadAllComments(db, 1000);
                            if (task.getReplyCount() == -1) {
                                this.deleted = true;
                            } else {
                                task.loadUri(db, group);
                                xml.writeDiscussion(task, "task", db, null, true, true, true, null);
                            }
                        }
                    } else {
                        this.mediatype = "application/vnd.pageseeder.comment+xml";
                        if (!this.deleted) {
                            this.deleted = XLinks.isArchived((XLink)xl);
                        }
                        if (!this.deleted && "Workflow".equals(xl.getContentRole())) {
                            this.deleted = true;
                        }
                        Long l = this.deleteID = xl == null ? this.id : xl.getId();
                        if (!this.deleted) {
                            xml.writeComment(xl, db, null, null, true, true, true, true, null);
                        }
                    }
                    this.content = xml.toString().getBytes(StandardCharsets.UTF_8);
                }
                if (xl != null && (loc = LocatorRule.getLocatorByXLink((XLink)xl)) != null) {
                    this.publicationsAsXML = IndexUtils.getPublicationsXML(db, loc);
                }
                tr.commit();
            }
            catch (Exception ex) {
                if (tr != null) {
                    tr.abort();
                }
                throw ex;
            }
            finally {
                db.close();
                db = null;
            }
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to resolve content", ex);
        }
        finally {
            this.resolved = true;
        }
    }
}

