/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.search.flint.PSTranslatorWrapper;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.content.ContentTranslator;
import org.pageseeder.flint.content.ContentTranslatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PSTranslatorFactory
implements ContentTranslatorFactory {
    public static final int MAX_INDEXING_SIZE = 30000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(PSTranslatorFactory.class);
    private final Map<String, ContentTranslator> translators = new ConcurrentHashMap<String, ContentTranslator>();

    public PSTranslatorFactory() {
        Properties mapping = Settings.getProperties((SettingsFile)SettingsFile.INDEX);
        for (Map.Entry<Object, Object> property : mapping.entrySet()) {
            String className;
            String mediaType = property.getKey().toString();
            ContentTranslator translator = PSTranslatorFactory.toTranslator(mediaType, className = property.getValue().toString());
            if (translator == null) continue;
            this.translators.put(mediaType, translator);
        }
        this.translators.put("application/vnd.pageseeder.comment+xml", new PSTranslatorWrapper("application/vnd.pageseeder.comment+xml"));
        this.translators.put("application/vnd.pageseeder.task+xml", new PSTranslatorWrapper("application/vnd.pageseeder.task+xml"));
        this.translators.put("application/vnd.pageseeder.url+xml", new PSTranslatorWrapper("application/vnd.pageseeder.url+xml"));
    }

    public @Nullable ContentTranslator createTranslator(@Nullable String mediaType) {
        return mediaType == null ? null : this.translators.get(mediaType);
    }

    public Collection<String> getMimeTypesSupported() {
        return Collections.unmodifiableCollection(this.translators.keySet());
    }

    private static @Nullable ContentTranslator toTranslator(String mediatype, String className) {
        try {
            Class<?> translatorClass = Class.forName(className);
            ContentTranslator translator = (ContentTranslator)translatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new PSTranslatorWrapper(mediatype, translator);
        }
        catch (NoSuchMethodException ex) {
            LOGGER.error("Unable to find default constructor for ContentTranslator {}", (Object)className, (Object)ex);
        }
        catch (InvocationTargetException ex) {
            LOGGER.error("Failed to invoke constructor for ContentTranslator {}", (Object)className, (Object)ex);
        }
        catch (ClassCastException ex) {
            LOGGER.error("Failed to cast {} to ContentTranslator", (Object)className, (Object)ex);
        }
        catch (InstantiationException | LinkageError ex) {
            LOGGER.error("Failed to instantiate ContentTranslator {}", (Object)className, (Object)ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.error("Failed to access ContentTranslator class {}", (Object)className, (Object)ex);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.error("ContentTranslator class {} not found", (Object)className, (Object)ex);
        }
        return null;
    }
}

