/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.search.flint.DocumentContent;
import com.pageseeder.search.flint.FolderContent;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import com.pageseeder.search.flint.PSHelpContent;
import com.pageseeder.search.flint.URLContent;
import com.pageseeder.search.flint.XLinkContent;
import com.pageseeder.search.url.URLsIndex;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentFetcher;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.indexing.IndexJob;

public final class PSContentFetcher
implements ContentFetcher {
    public @Nullable Content getContent(IndexJob job) {
        Index index = job.getIndex();
        String contentID = job.getContentID();
        ContentType contentType = job.getContentType();
        if ("help".equals(index.getIndexID())) {
            return new PSHelpContent(contentID);
        }
        if (contentType == PSContentType.COMMENT) {
            Long id = IndexUtils.getCommentContentID(contentID);
            if (IndexUtils.isContentDeleted(contentID)) {
                return XLinkContent.deleteXLinkContent(id, false);
            }
            return new XLinkContent(id, Long.parseLong(index.getIndexID()), false);
        }
        if (contentType == PSContentType.TASK) {
            Long id = IndexUtils.getCommentContentID(contentID);
            if (IndexUtils.isContentDeleted(contentID)) {
                return XLinkContent.deleteXLinkContent(id, true);
            }
            return new XLinkContent(id, Long.parseLong(index.getIndexID()), true);
        }
        Long[] ids = IndexUtils.getURIContentIDs(contentID);
        if (contentType == PSContentType.FOLDER) {
            return new FolderContent(ids[0], Long.parseLong(index.getIndexID()));
        }
        if (contentType == PSContentType.URL) {
            if (IndexUtils.isContentDeleted(contentID)) {
                return URLContent.deleteURLContent(ids[0], ids[1]);
            }
            Long gpid = index instanceof URLsIndex ? null : Long.valueOf(Long.parseLong(index.getIndexID()));
            return new URLContent(ids[0], gpid, ids[1], true);
        }
        if (contentType == PSContentType.DOCUMENT) {
            if (IndexUtils.isContentDeleted(contentID)) {
                return DocumentContent.deleteDocumentContent(ids[0], ids[1]);
            }
            return new DocumentContent(ids[0], Long.parseLong(index.getIndexID()), ids[1], job);
        }
        return null;
    }
}

