/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.model.Group;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import org.apache.lucene.analysis.Analyzer;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupIndex
extends LuceneIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupIndex.class);
    private static final String PSGROUPNAME_FIELD_NAME = "psgroupname";
    private static final String PSGROUPID_FIELD_NAME = "psgroupid";
    private static final String INDEX_TEMPLATE_FOLDER = "index";
    private final String catalog;
    private final Map<String, String> originalParameters;
    private final Template template;
    private final String groupname;
    private final Long groupid;

    public static @Nullable String getCatalogName(@Nullable Group group) {
        if (group == null) {
            return null;
        }
        return group.getOwnerDirectory() == null ? group.getName() : group.getOwnerDirectory();
    }

    public GroupIndex(File dir, Group group, Analyzer analyzer, File webapp) throws IOException, IndexException {
        super(String.valueOf(group.getId()), dir, analyzer);
        this.catalog = GroupIndex.getCatalogName(group);
        this.originalParameters = new ConcurrentHashMap<String, String>();
        this.addTimezoneParameters();
        String style = group.getOwnerDirectory();
        this.template = new Template(style == null ? "default" : style);
        this.groupid = group.getId();
        this.groupname = group.getName();
    }

    public Long getGroupID() {
        return this.groupid;
    }

    public void clear() {
        this.originalParameters.clear();
        this.addTimezoneParameters();
    }

    public void addParameter(String name, String value) {
        this.originalParameters.put(name, value);
    }

    public void addParameters(Map<String, String> params) {
        this.originalParameters.putAll(params);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Collection<FlintField> getFields(Content content) {
        ArrayList<FlintField> fields = new ArrayList<FlintField>();
        fields.add(new FlintField(this.catalog).name(PSGROUPNAME_FIELD_NAME).tokenize(false).value(this.groupname));
        fields.add(new FlintField(this.catalog).name(PSGROUPID_FIELD_NAME).tokenize(false).numeric(FlintField.NumericType.LONG).docValues(FlintField.DocValuesType.SORTED_NUMERIC).value(String.valueOf(this.groupid)));
        return fields;
    }

    public Templates getTemplates(ContentType type, String mimeType) {
        Templates loaded = super.getTemplates(type, mimeType);
        if (loaded != null) {
            return loaded;
        }
        String templateName = "index-" + mimeType.toLowerCase().replaceAll("\\W", "-");
        File templateFolder = this.findIndexTemplate(templateName);
        if (templateFolder == null) {
            templateFolder = this.findIndexTemplate(INDEX_TEMPLATE_FOLDER);
        }
        if (templateFolder == null) {
            return null;
        }
        try {
            this.setTemplates(type, mimeType, templateFolder.toURI());
        }
        catch (TransformerException ex) {
            LOGGER.error("Failed to load iXML templates {}", (Object)templateFolder.getName(), (Object)ex);
        }
        return super.getTemplates(type, mimeType);
    }

    public Map<String, String> getParameters(Content content) {
        return this.originalParameters;
    }

    public String toString() {
        String id = this.getIndexID().replace(File.separatorChar, '/');
        return "Index for Group " + id.substring(id.lastIndexOf(47) + 1);
    }

    public @Nullable File findIndexTemplate(String name) {
        File webapp = new File(Settings.getContextPath());
        return TemplateFiles.find((Template)this.template, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)("index/" + name + ".xsl"));
    }

    private void addTimezoneParameters() {
        TimeZone tz = TimeZone.getDefault();
        this.originalParameters.put("timezone.offset", this.offsetAsString(tz.getOffset(System.currentTimeMillis())));
        this.originalParameters.put("timezone.rawoffset", this.offsetAsString(tz.getRawOffset()));
    }

    private String offsetAsString(int offsetinMS) {
        double offset = offsetinMS / 3600000;
        double offsetAbs = Math.abs(offset);
        int minutes = (int)(offsetAbs - (double)((int)offsetAbs)) * 100;
        return (offset != offsetAbs ? "-" : "+") + (offsetAbs < 10.0 ? "0" : "") + (int)offsetAbs + ":" + (minutes < 10 ? "0" : "") + minutes;
    }
}

