/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupIndexReindexing {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupIndexReindexing.class);
    private static final Map<Long, GroupIndexBatch> REINDEXING = new ConcurrentHashMap<Long, GroupIndexBatch>();

    private GroupIndexReindexing() {
    }

    static void startReindexing(Long groupid, String batch, boolean server) {
        REINDEXING.put(groupid, new GroupIndexBatch(batch, server));
        LOGGER.debug("Reindexing {} groups", (Object)REINDEXING.size());
    }

    public static boolean stopReindexing(Long groupid) {
        GroupIndexBatch gib = REINDEXING.remove(groupid);
        boolean server = gib != null && gib.serverIndexing;
        LOGGER.debug("Still reindexing {} groups, server indexing {}", (Object)REINDEXING.size(), (Object)server);
        return server;
    }

    public static boolean isReindexingBatch(Long groupid, @Nullable String batch) {
        return GroupIndexReindexing.isReindexing(groupid) && batch != null && batch.equals(GroupIndexReindexing.REINDEXING.get((Object)groupid).batchid);
    }

    public static boolean isReindexing(Long groupid) {
        return REINDEXING.containsKey(groupid);
    }

    private static class GroupIndexBatch {
        private final String batchid;
        private final boolean serverIndexing;

        private GroupIndexBatch(String bid, boolean server) {
            this.batchid = bid;
            this.serverIndexing = server;
        }
    }
}

