/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.Beta;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.IndexErrorID;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.lucene.query.DateParameter;
import org.pageseeder.flint.lucene.util.Documents;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true)
@Beta
public final class GetActivityOverPeriod
implements Generator,
SingleCheck {
    private static final int DEFAULT_NUMBER_OF_DAYS = 30;

    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        return new ViewGroupCheck(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        Database db = req.getDatabase();
        XMLWriter xml = res.getXMLWriter();
        String type = req.getParameter((Parameter)StandardParameters.type, "document");
        long days = (int)req.getParameter((Parameter)StandardParameters.days, 30L);
        xml.openElement("activity");
        xml.attribute("type", type);
        IndexMaster master = IndexMaster.getInstance();
        IndexSearcher searcher = null;
        if (master.isIndexable(db, group)) {
            try {
                searcher = master.getSearcher(db, group);
                if (searcher == null) {
                    Thread.yield();
                    searcher = master.getSearcher(db, group);
                }
                if (searcher != null) {
                    TermQuery base = new TermQuery(new Term("pstype", type));
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(10, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    Date to = calendar.getTime();
                    Date from = null;
                    int i = 0;
                    while ((long)i < days) {
                        calendar.add(5, -1);
                        from = calendar.getTime();
                        Query day = new DateParameter("psmodifieddate", from, to, DateTools.Resolution.MINUTE, false).toQuery();
                        BooleanQuery.Builder q = new BooleanQuery.Builder();
                        q.add((Query)base, BooleanClause.Occur.MUST);
                        q.add(day, BooleanClause.Occur.MUST);
                        int count = Documents.count((IndexSearcher)searcher, (Query)q.build());
                        xml.openElement("day");
                        xml.attribute("date", ISO8601.format((long)from.getTime(), (ISO8601)ISO8601.CALENDAR_DATE));
                        xml.attribute("count", count);
                        xml.closeElement();
                        to = from;
                        ++i;
                    }
                }
            }
            catch (IndexException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof IndexFormatTooOldException) {
                    res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)IndexErrorID.INDEX_TOO_OLD, "index-too-old");
                } else {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to perform search: " + ex.getMessage());
                }
                return;
            }
            finally {
                master.releaseSilently(db, group, searcher);
            }
        }
        xml.closeElement();
    }
}

