/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.Beta;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

@Requires(database=true)
@Beta
public final class About
implements Generator,
Cacheable {
    private static final String NUMBER_ATTRIBUTE = "com.pageseeder.search.About.numbers";
    private static final String PERSONAL_NUMBER_ATTRIBUTE = "com.pageseeder.search.About.personal";
    private static final String URLS_VERSION_ATTRIBUTE = "com.pageseeder.search.About.urlsVersion";

    public String getETag(GeneratorRequest req) {
        boolean personal = "personal".equals(req.getParameter((Parameter)StandardParameters.include));
        String prefix = req.getParameter((Parameter)StandardParameters.prefix, "");
        try {
            Database db = req.getDatabase();
            Integer[] numbers = this.sumIndexVersionNumbers(db, prefix);
            req.getHttpServletRequest().setAttribute(NUMBER_ATTRIBUTE, (Object)numbers);
            StringBuilder etag = new StringBuilder(prefix.hashCode());
            etag.append("-").append(numbers[0]).append("-").append(numbers[1]).append("-").append(numbers[2]);
            if (personal) {
                Integer[] personalNumbers = DatabaseQuery.getPersonalGroupsIndexVersionNumbers((Database)db);
                req.getHttpServletRequest().setAttribute(PERSONAL_NUMBER_ATTRIBUTE, (Object)personalNumbers);
                etag.append("-").append(personalNumbers[0]).append("-").append(personalNumbers[1]).append("-").append(personalNumbers[2]);
            }
            if (prefix.isEmpty()) {
                Group publicGroup = GroupRule.getPublicGroup((Database)db);
                String version = publicGroup.getIndexVersion() == null ? "0" : publicGroup.getIndexVersion().toString();
                req.getHttpServletRequest().setAttribute(URLS_VERSION_ATTRIBUTE, (Object)version);
                etag.append("-").append(version);
            }
            return etag.toString();
        }
        catch (QueryFailedException ex) {
            return null;
        }
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Integer[] numbers;
        Database db = req.getDatabase();
        String prefix = req.getParameter((Parameter)StandardParameters.prefix, "");
        boolean personal = "personal".equals(req.getParameter((Parameter)StandardParameters.include));
        Object loaded = req.getHttpServletRequest().getAttribute(NUMBER_ATTRIBUTE);
        if (loaded instanceof Integer[]) {
            numbers = (Integer[])loaded;
        } else {
            try {
                numbers = this.sumIndexVersionNumbers(db, prefix);
            }
            catch (QueryFailedException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load Index Version numbers: " + ex.getMessage());
                return;
            }
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("about-index");
        out.startObject("index");
        out.field("version", (long)Settings.CURRENT_INDEX_VERSION.intValue());
        out.endObject();
        out.startObject("groups");
        if (prefix != null) {
            out.field("prefix", prefix);
        }
        out.field("current", (long)numbers[0].intValue());
        out.field("old", (long)numbers[1].intValue());
        out.field("obsolete", (long)numbers[2].intValue());
        out.endObject();
        if (personal) {
            Integer[] personalNumbers;
            loaded = req.getHttpServletRequest().getAttribute(PERSONAL_NUMBER_ATTRIBUTE);
            if (loaded instanceof Integer[]) {
                personalNumbers = (Integer[])loaded;
            } else {
                try {
                    personalNumbers = DatabaseQuery.getPersonalGroupsIndexVersionNumbers((Database)db);
                }
                catch (QueryFailedException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load personal groups Index Version numbers: " + ex.getMessage());
                    return;
                }
            }
            out.startObject("personal-groups");
            out.field("current", (long)personalNumbers[0].intValue());
            out.field("old", (long)personalNumbers[1].intValue());
            out.field("obsolete", (long)personalNumbers[2].intValue());
            out.endObject();
        }
        if (prefix == null) {
            out.startObject("urls");
            String version = null;
            loaded = req.getHttpServletRequest().getAttribute(URLS_VERSION_ATTRIBUTE);
            if (loaded instanceof String) {
                version = (String)loaded;
            } else {
                try {
                    Group publicGroup = GroupRule.getPublicGroup((Database)db);
                    version = publicGroup.getIndexVersion() == null ? "0" : publicGroup.getIndexVersion().toString();
                }
                catch (DatabaseException ex) {
                    out.field("error", "failed to load urls index version: " + ex.getMessage());
                }
            }
            out.field("version", version == null ? "0" : version);
            out.endObject();
        }
        out.endObject();
    }

    private Integer[] sumIndexVersionNumbers(Database db, String groupPrefixes) throws QueryFailedException {
        Integer[] numbers = new Integer[]{0, 0, 0};
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String pref : groupPrefixes.split(",")) {
            pref = pref.isEmpty() || pref.endsWith("-") ? pref.trim() : pref.trim() + "-";
            prefixes.add(pref);
        }
        Collections.sort(prefixes);
        String ancestor = " ";
        for (String pref : prefixes) {
            if (pref.startsWith(ancestor)) continue;
            ancestor = pref;
            Integer[] num = DatabaseQuery.getIndexVersionNumbers((Database)db, (String)pref);
            Integer[] integerArray = numbers;
            Integer.valueOf(integerArray[0] + num[0]);
            integerArray = numbers;
            Integer.valueOf(integerArray[1] + num[1]);
            integerArray = numbers;
            Integer.valueOf(integerArray[2] + num[2]);
        }
        return numbers;
    }
}

