/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.pdf.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.pageseeder.pdf.PDFException;

public class Files {
    private Files() {
    }

    public static void copy(File from, File to) throws IOException {
        Files.ensureDirectoryExists(to.getParentFile());
        if (!to.exists()) {
            to.createNewFile();
        }
        try (FileInputStream in = new FileInputStream(from);
             FileOutputStream out = new FileOutputStream(to);){
            FileChannel source = in.getChannel();
            FileChannel destination = out.getChannel();
            destination.transferFrom(source, 0L, source.size());
        }
    }

    public static void ensureDirectoryExists(File directory) throws PDFException {
        boolean done;
        if (!directory.exists() && !(done = directory.mkdirs())) {
            throw new PDFException("Unable to create target directory for preprocessor");
        }
    }
}

