/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.job;

import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.webhook.event.Event;
import com.pageseeder.webhook.event.EventsCache;
import com.pageseeder.webhook.job.Job;
import com.pageseeder.webhook.job.JobPoster;
import com.pageseeder.webhook.job.JobsQueue;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobsThread.class);
    private static boolean shouldStop = false;
    private static final int DELAY_MS = 500;
    private final JobsQueue queue;
    private final EventsCache eventsCache;
    private final JobPoster poster;

    public JobsThread(JobsQueue q, EventsCache evts) {
        this.queue = q;
        this.eventsCache = evts;
        this.poster = new JobPoster();
    }

    @Override
    public void run() {
        do {
            try {
                Job job = this.queue.next();
                while (job != null) {
                    this.processJob(job);
                    job = this.queue.next();
                }
            }
            catch (Throwable ex) {
                LOGGER.error("Webhook job thread error", ex);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                if (shouldStop) continue;
                LOGGER.warn("Jobs thread interrupted, closing!");
                break;
            }
        } while (!shouldStop);
    }

    public static void stop() {
        shouldStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJob(Job job) {
        Database db = null;
        Transaction tr = null;
        try {
            db = Database.open();
            tr = new Transaction(db);
            tr.begin();
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to open database", (Throwable)ex);
            return;
        }
        try {
            Webhook webhook;
            try {
                webhook = WebhookQuery.getWebhook((Database)db, (Long)job.getWebhoookID());
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load webhook with ID {}", (Object)job.getWebhoookID(), (Object)ex);
                tr.abort();
                if (db != null) {
                    db.close();
                }
                db = null;
                return;
            }
            if (webhook == null) {
                LOGGER.warn("Failed to load webhook with ID {}", (Object)job.getWebhoookID());
                tr.abort();
                return;
            }
            Webhook.Status status = webhook.getStatus();
            if (status == Webhook.Status.pending || status == Webhook.Status.disabled || status == Webhook.Status.unreachable) {
                LOGGER.info("Ignoring webhook with ID {} and status {}", (Object)job.getWebhoookID(), (Object)webhook.getStatus().name());
                tr.abort();
                return;
            }
            ArrayList<Event> events = new ArrayList<Event>();
            for (String eventID : job.getEvents()) {
                Event event = this.eventsCache.get(eventID);
                if (event == null) {
                    LOGGER.error("Failed to load event with ID {} from cache for webhook {} with URL {}", new Object[]{eventID, webhook.getId(), webhook.getURL()});
                    webhook.setStatus(Webhook.Status.error);
                    continue;
                }
                events.add(event);
            }
            if (events.isEmpty()) {
                LOGGER.error("Ignoring job {} without events for webhook {}", (Object)job.getID(), (Object)webhook.getId());
                tr.abort();
                return;
            }
            LOGGER.debug("Found new job for webhook {} with {} events", (Object)webhook.getId(), (Object)events.size());
            if (!this.poster.post(webhook, events)) {
                webhook.setStatus(Webhook.Status.warning);
                this.queue.addFailed(job);
            }
            try {
                tr.commit();
            }
            catch (CommitTransactionException ex) {
                LOGGER.error("Failed to commit transaction", (Throwable)ex);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
            db = null;
        }
    }
}

