/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.job;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.util.Base64;
import com.pageseeder.common.util.MD5;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.webhook.event.Event;
import com.pageseeder.webhook.manager.WebhookManager;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobPoster {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobPoster.class);
    private static final String PING_HEADER = "X-PS-Secret";
    private static final String SIGNATURE_HEADER = "X-PS-Signature";
    private static final String SIGNATURE_ALGORITHM = "HmacSHA256";
    private static @Nullable SSLSocketFactory insecureSslSocketFactory = null;
    private static @Nullable HostnameVerifier insecureSslHostnameVerifier = null;
    private @Nullable String errorMessage = null;

    public @Nullable String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean post(Webhook webhook, Collection<Event> events) {
        this.errorMessage = null;
        try {
            String secret;
            HttpURLConnection con = (HttpURLConnection)new URL(webhook.getURL()).openConnection();
            con.setDoOutput(true);
            con.setInstanceFollowRedirects(false);
            if (webhook.getInsecureSSL() == Boolean.TRUE && con instanceof HttpsURLConnection) {
                ((HttpsURLConnection)con).setSSLSocketFactory(JobPoster.insecureSSLSocketFactory());
                ((HttpsURLConnection)con).setHostnameVerifier(JobPoster.insecureSSLHostnameVerifier());
            }
            con.setRequestMethod("POST");
            con.setDoInput(true);
            con.setRequestProperty("Content-Type", "application/" + webhook.getFormat().name() + "; charset=UTF-8");
            String pingSecret = null;
            for (Event event : events) {
                if (!event.isPing()) continue;
                pingSecret = MD5.hash((String)("allez les verts!" + System.nanoTime())).substring(5, 15);
                con.setRequestProperty(PING_HEADER, pingSecret);
                break;
            }
            if ((secret = webhook.getClient().getWebhookSecret()) != null && !secret.isEmpty()) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                this.writeEvents(webhook, events, output);
                byte[] signature = this.generateSignature(secret, output.toByteArray());
                if (signature != null) {
                    con.setRequestProperty(SIGNATURE_HEADER, new String(Base64.encode((byte[])signature)));
                }
                con.connect();
                con.getOutputStream().write(output.toByteArray());
            } else {
                con.connect();
                this.writeEvents(webhook, events, con.getOutputStream());
            }
            return this.handlePostResponse(webhook, con, pingSecret);
        }
        catch (IOException ex) {
            LOGGER.warn("Error \"{}\" when posting job to webhook {} on URL {}", new Object[]{ex.getMessage(), webhook.getId(), webhook.getURL()});
            this.errorMessage = "Failed to post to webhook (" + (ex.getMessage() == null ? "unknown error" : ex.getMessage()) + ")";
            return false;
        }
    }

    private boolean handlePostResponse(Webhook webhook, HttpURLConnection con, @Nullable String pingSecret) throws IOException {
        int code = con.getResponseCode();
        if (code >= 200 && code < 300) {
            if (pingSecret != null) {
                String pingResponse = con.getHeaderField(PING_HEADER);
                if (pingSecret.equals(pingResponse)) {
                    webhook.setStatus(Webhook.Status.active);
                    WebhookManager.getInstance().addEventFilters(webhook);
                } else {
                    this.errorMessage = pingResponse == null ? "Missing ping header" : "Invalid ping header";
                    LOGGER.warn("Got wrong response from ping to webhook {} on URL {}: header was {} instead of {}", new Object[]{webhook.getId(), webhook.getURL(), pingResponse, pingSecret});
                }
            }
            if (webhook.getStatus().equals((Object)Webhook.Status.warning)) {
                webhook.setStatus(Webhook.Status.active);
                WebhookManager.getInstance().addEventFilters(webhook);
            }
            return true;
        }
        if (code >= 300 && code < 400 || code == 410) {
            this.errorMessage = "Failed to post to webhook (HTTP code is " + code + ")";
            webhook.setStatus(Webhook.Status.unreachable);
            LOGGER.warn("Error {} when posting job to webhook {} on URL {}", new Object[]{code, webhook.getId(), webhook.getURL()});
            return true;
        }
        LOGGER.warn("Error {} when posting job to webhook {} on URL {}", new Object[]{code, webhook.getId(), webhook.getURL()});
        this.errorMessage = "Failed to post to webhook (HTTP code is " + code + ")";
        return false;
    }

    private static SSLSocketFactory insecureSSLSocketFactory() {
        if (insecureSslSocketFactory == null) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                insecureSslSocketFactory = sslContext.getSocketFactory();
            }
            catch (KeyManagementException | NoSuchAlgorithmException ex) {
                LOGGER.error("Faile to create insecure SSL socket factory", (Throwable)ex);
            }
        }
        return insecureSslSocketFactory;
    }

    private static HostnameVerifier insecureSSLHostnameVerifier() {
        if (insecureSslHostnameVerifier == null) {
            insecureSslHostnameVerifier = (hostname, sslSession) -> true;
        }
        return insecureSslHostnameVerifier;
    }

    private void writeEvents(Webhook webhook, Collection<Event> events, OutputStream output) {
        try (UniversalPrinter out = JobPoster.asUniversalPrinter(output, webhook.getFormat());){
            String name = webhook.getName();
            out.startObject("webevents");
            out.startObject("webhook");
            out.field("id", webhook.getId().longValue());
            if (name != null) {
                out.field("name", name);
            }
            out.endObject();
            out.startCollection("webevents", OutputPrinter.CollectionOption.JSON_ONLY);
            for (Event event : events) {
                event.print((OutputPrinter)out, webhook);
            }
            out.endCollection();
            out.endObject();
            out.flush();
        }
    }

    private static UniversalPrinter asUniversalPrinter(OutputStream output, Webhook.Format format) {
        OutputType type = format == Webhook.Format.xml ? OutputType.XML : OutputType.JSON;
        return UniversalPrinter.newWriter((Writer)new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8)), (OutputType)type);
    }

    private byte[] generateSignature(String secret, byte[] content) {
        SecretKeySpec key = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "AES");
        byte[] signed = null;
        try {
            Mac mac = Mac.getInstance(SIGNATURE_ALGORITHM);
            mac.init(key);
            signed = mac.doFinal(content);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error("Invalid algorithm {}", (Object)SIGNATURE_ALGORITHM, (Object)ex);
        }
        catch (InvalidKeyException ex) {
            LOGGER.error("Invalid secret {}", (Object)secret, (Object)ex);
        }
        return signed;
    }
}

