/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.attributes;

import java.awt.Font;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.support.attributes.FontFamily;
import net.sourceforge.jeuclid.elements.support.text.CharacterMapping;
import net.sourceforge.jeuclid.font.FontFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MathVariant
implements Serializable {
    public static final MathVariant BOLD = new MathVariant(1, FontFamily.SERIF);
    public static final MathVariant BOLD_FRAKTUR = new MathVariant(1, FontFamily.FRAKTUR);
    public static final MathVariant BOLD_ITALIC = new MathVariant(3, FontFamily.SERIF);
    public static final MathVariant BOLD_SANS_SERIF = new MathVariant(1, FontFamily.SANSSERIF);
    public static final MathVariant BOLD_SCRIPT = new MathVariant(1, FontFamily.SCRIPT);
    public static final MathVariant DOUBLE_STRUCK = new MathVariant(0, FontFamily.DOUBLE_STRUCK);
    public static final MathVariant FRAKTUR = new MathVariant(0, FontFamily.FRAKTUR);
    public static final MathVariant ITALIC = new MathVariant(2, FontFamily.SERIF);
    public static final MathVariant MONOSPACE = new MathVariant(0, FontFamily.MONOSPACED);
    public static final MathVariant NORMAL = new MathVariant(0, FontFamily.SERIF);
    public static final MathVariant SANS_SERIF = new MathVariant(0, FontFamily.SANSSERIF);
    public static final MathVariant SANS_SERIF_BOLD_ITALIC = new MathVariant(3, FontFamily.SANSSERIF);
    public static final MathVariant SANS_SERIF_ITALIC = new MathVariant(2, FontFamily.SANSSERIF);
    public static final MathVariant SCRIPT = new MathVariant(0, FontFamily.SCRIPT);
    private static final Map<String, MathVariant> ATTRIBUTEMAP = new HashMap<String, MathVariant>();
    private static final Map<FontFamily, Parameter> PARAMFORFONT = new HashMap<FontFamily, Parameter>();
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(CharacterMapping.class);
    private static final Set<Integer> WARNED = new HashSet<Integer>();
    private final int awtStyle;
    private final FontFamily fontFamily;

    public MathVariant(int n, FontFamily fontFamily) {
        this.awtStyle = n;
        this.fontFamily = fontFamily;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MathVariant stringToMathVariant(String string) {
        Map<String, MathVariant> map = ATTRIBUTEMAP;
        synchronized (map) {
            if (ATTRIBUTEMAP.isEmpty()) {
                ATTRIBUTEMAP.put("normal", NORMAL);
                ATTRIBUTEMAP.put("bold", BOLD);
                ATTRIBUTEMAP.put("italic", ITALIC);
                ATTRIBUTEMAP.put("bold-italic", BOLD_ITALIC);
                ATTRIBUTEMAP.put("double-struck", DOUBLE_STRUCK);
                ATTRIBUTEMAP.put("bold-fraktur", BOLD_FRAKTUR);
                ATTRIBUTEMAP.put("script", SCRIPT);
                ATTRIBUTEMAP.put("bold-script", BOLD_SCRIPT);
                ATTRIBUTEMAP.put("fraktur", FRAKTUR);
                ATTRIBUTEMAP.put("sans-serif", SANS_SERIF);
                ATTRIBUTEMAP.put("bold-sans-serif", BOLD_SANS_SERIF);
                ATTRIBUTEMAP.put("sans-serif-italic", SANS_SERIF_ITALIC);
                ATTRIBUTEMAP.put("sans-serif-bold-italic", SANS_SERIF_BOLD_ITALIC);
                ATTRIBUTEMAP.put("monospace", MONOSPACE);
            }
            return ATTRIBUTEMAP.get(string.toLowerCase(Locale.ENGLISH));
        }
    }

    public Font createFont(float f, int n, LayoutContext layoutContext, boolean bl) {
        Parameter parameter = PARAMFORFONT.get((Object)this.fontFamily);
        Font font = FontFactory.getInstance().getFont((List)layoutContext.getParameter(parameter), n, this.awtStyle, f);
        if (bl && font == null) {
            if (!WARNED.contains(n)) {
                WARNED.add(n);
                String string = Integer.toHexString(n);
                LOGGER.warn((Object)("No font available to display character " + string));
                LOGGER.info((Object)("Find a font at  http://www.fileformat.info/info/unicode/char/" + string + "/fontsupport.htm or http://www.alanwood.net/unicode/search.html"));
            }
            return FontFactory.getInstance().getFont("sansserif", this.awtStyle, f);
        }
        return font;
    }

    public int getAwtStyle() {
        return this.awtStyle;
    }

    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    public int hashCode() {
        int n = this.fontFamily == null ? 0 : this.fontFamily.hashCode();
        n = 31 * n + this.awtStyle;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MathVariant mathVariant = (MathVariant)object;
        if (this.awtStyle != mathVariant.awtStyle) {
            return false;
        }
        return !(this.fontFamily == null ? mathVariant.fontFamily != null : !this.fontFamily.equals((Object)mathVariant.fontFamily));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append((Object)this.fontFamily);
        if (this.awtStyle > 0) {
            stringBuilder.append(' ');
        }
        if ((this.awtStyle & 1) > 0) {
            stringBuilder.append('B');
        }
        if ((this.awtStyle & 2) > 0) {
            stringBuilder.append('I');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        PARAMFORFONT.put(FontFamily.SERIF, Parameter.FONTS_SERIF);
        PARAMFORFONT.put(FontFamily.SANSSERIF, Parameter.FONTS_SANSSERIF);
        PARAMFORFONT.put(FontFamily.MONOSPACED, Parameter.FONTS_MONOSPACED);
        PARAMFORFONT.put(FontFamily.SCRIPT, Parameter.FONTS_SCRIPT);
        PARAMFORFONT.put(FontFamily.FRAKTUR, Parameter.FONTS_FRAKTUR);
        PARAMFORFONT.put(FontFamily.DOUBLE_STRUCK, Parameter.FONTS_DOUBLESTRUCK);
    }
}

