/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.nio.charset.Charset;

public final class OutputOptions {
    private static final OutputOptions DEFAULT = new OutputOptions("utf-8", false, false, false);
    private static final OutputOptions DEFAULT_COMPATIBILITY = new OutputOptions("utf-8", true, true, true);
    private final String encoding;
    private final boolean indent;
    private final boolean omitXmlDeclaration;
    private final boolean usePrefixInLocation;

    private OutputOptions(String encoding, boolean indent, boolean omitXmlDeclaration, boolean usePrefixInLocation) {
        this.encoding = encoding;
        this.indent = indent;
        this.omitXmlDeclaration = omitXmlDeclaration;
        this.usePrefixInLocation = usePrefixInLocation;
    }

    public static OutputOptions defaults() {
        if ("1.0".equals(System.getProperty("org.pageseeder.schematron.compatibility"))) {
            return DEFAULT_COMPATIBILITY;
        }
        return DEFAULT;
    }

    public OutputOptions encoding(String encoding) {
        Charset.forName(encoding);
        return new OutputOptions(encoding, this.indent, this.omitXmlDeclaration, this.usePrefixInLocation);
    }

    public OutputOptions indent(boolean indent) {
        return new OutputOptions(this.encoding, indent, this.omitXmlDeclaration, this.usePrefixInLocation);
    }

    public OutputOptions omitXmlDeclaration(boolean omitXmlDeclaration) {
        return new OutputOptions(this.encoding, this.indent, omitXmlDeclaration, this.usePrefixInLocation);
    }

    public OutputOptions usePrefixInLocation(boolean usePrefixInLocation) {
        return new OutputOptions(this.encoding, this.indent, this.omitXmlDeclaration, usePrefixInLocation);
    }

    public String encoding() {
        return this.encoding;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public boolean isOmitXmlDeclaration() {
        return this.omitXmlDeclaration;
    }

    public boolean usePrefixInLocation() {
        return this.usePrefixInLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutputOptions that = (OutputOptions)o;
        if (this.indent != that.indent) {
            return false;
        }
        if (this.omitXmlDeclaration != that.omitXmlDeclaration) {
            return false;
        }
        if (this.usePrefixInLocation != that.usePrefixInLocation) {
            return false;
        }
        return this.encoding.equals(that.encoding);
    }

    public int hashCode() {
        int result = this.encoding.hashCode();
        result = 31 * result + (this.indent ? 1 : 0);
        result = 31 * result + (this.omitXmlDeclaration ? 1 : 0);
        result = 31 * result + (this.usePrefixInLocation ? 1 : 0);
        return result;
    }

    public String toString() {
        return "OutputOptions{encoding='" + this.encoding + '\'' + ", indent=" + this.indent + ", omitXmlDeclaration=" + this.omitXmlDeclaration + ", usePrefixInLocation=" + this.usePrefixInLocation + '}';
    }
}

