/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.docx.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.pageseeder.docx.DOCXException;
import org.pageseeder.docx.util.Files;

public final class ZipUtils {
    private static final int BUFFER = 2048;

    private ZipUtils() {
    }

    public static void unzip(File src, File dest) {
        try (ZipFile zip = new ZipFile(src);){
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                String folder;
                File dir;
                ZipEntry entry = e.nextElement();
                String name = entry.getName();
                if (name.indexOf(47) > 0 && !(dir = Files.descendantFile(dest, folder = name.substring(0, name.lastIndexOf(47)))).exists()) {
                    dir.mkdirs();
                }
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                byte[] data = new byte[2048];
                File f = Files.descendantFile(dest, name);
                FileOutputStream fos = new FileOutputStream(f);
                try (BufferedOutputStream out = new BufferedOutputStream(fos, 2048);){
                    int count;
                    while ((count = is.read(data, 0, 2048)) != -1) {
                        out.write(data, 0, count);
                    }
                    out.flush();
                    is.close();
                }
            }
        }
        catch (IOException ex) {
            throw new DOCXException(ex);
        }
    }

    public static void zip(File src, File dest) {
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));){
            if (src.isFile()) {
                ZipUtils.addToZip(src, out, null);
            } else {
                File[] children = src.listFiles();
                if (children != null) {
                    for (File f : children) {
                        ZipUtils.addToZip(f, out, null);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new DOCXException(ex);
        }
    }

    private static void addToZip(File file, ZipOutputStream out, String folder) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    ZipUtils.addToZip(f, out, (String)(folder != null ? folder + file.getName() : file.getName()) + "/");
                }
            }
        } else {
            byte[] data = new byte[2048];
            try (BufferedInputStream origin = new BufferedInputStream(new FileInputStream(file), 2048);){
                int count;
                ZipEntry entry = new ZipEntry((String)(folder != null ? folder + file.getName() : file.getName()));
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
            }
            catch (IOException ex) {
                throw new DOCXException(ex);
            }
        }
    }
}

