/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.authorizer;

import com.pageseeder.base.oauth.core.OAuthErrorType;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.base.oauth.core.OAuthRequest;
import com.pageseeder.base.oauth.core.OAuthRequestValidator;
import com.pageseeder.common.oauth.GrantType;
import com.pageseeder.common.util.Strings;
import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;

public final class TokenRequest
extends OAuthRequest {
    private static final EnumSet<GrantType> ALLOWED_GRANT_TYPES = EnumSet.of(GrantType.authorization_code, GrantType.password, GrantType.client_credentials, GrantType.refresh_token);
    private final GrantType grantType;

    private TokenRequest(HttpServletRequest request, GrantType grantType) {
        super(request);
        this.grantType = grantType;
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    public String getPassword() {
        return this.getParameter(OAuthParameter.password);
    }

    public String getUsername() {
        return this.getParameter(OAuthParameter.username);
    }

    public String getRefreshToken() {
        return this.getParameter(OAuthParameter.refresh_token);
    }

    public String getCode() {
        return this.getParameter(OAuthParameter.code);
    }

    public static TokenRequest newInstance(HttpServletRequest req) throws OAuthException {
        String grantType = req.getParameter(OAuthParameter.grant_type.name());
        GrantType type = TokenRequest.toGrantType(grantType);
        OAuthRequestValidator validator = TokenRequest.getValidator(type);
        TokenRequest oauth = new TokenRequest(req, type);
        validator.validate((OAuthRequest)oauth);
        return oauth;
    }

    private static GrantType toGrantType(String grantType) throws OAuthException {
        if (Strings.isEmpty((String)grantType)) {
            throw OAuthException.newInvalidRequest((String)"Missing grant_type parameter value");
        }
        for (GrantType type : ALLOWED_GRANT_TYPES) {
            if (!type.toString().equals(grantType)) continue;
            return type;
        }
        throw OAuthException.error((OAuthErrorType)OAuthErrorType.unsupported_grant_type, (String)"Unsupported grant_type parameter value");
    }

    private static OAuthRequestValidator getValidator(GrantType type) throws OAuthException {
        switch (type) {
            case password: {
                return OAuthRequestValidator.create().requires(new OAuthParameter[]{OAuthParameter.grant_type, OAuthParameter.username, OAuthParameter.password}).acceptsMethod(new String[]{"POST"});
            }
            case client_credentials: {
                return OAuthRequestValidator.create().requires(new OAuthParameter[]{OAuthParameter.grant_type}).acceptsMethod(new String[]{"POST"}).isAuthenticated();
            }
            case authorization_code: {
                return OAuthRequestValidator.create().requires(new OAuthParameter[]{OAuthParameter.grant_type, OAuthParameter.code}).acceptsMethod(new String[]{"POST"});
            }
            case refresh_token: {
                return OAuthRequestValidator.create().requires(new OAuthParameter[]{OAuthParameter.grant_type, OAuthParameter.refresh_token}).acceptsMethod(new String[]{"POST"});
            }
        }
        throw OAuthException.error((OAuthErrorType)OAuthErrorType.unsupported_grant_type, (String)"Unsupported grant_type parameter value");
    }
}

