/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.authorizer;

import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class RevocationServlet
extends HttpServlet {
    private static final long serialVersionUID = 3151690511827797283L;

    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        WebRequest wr = new WebRequest(req, res);
        String token = wr.getParameter("token", true);
        if (token == null) {
            return;
        }
        @Nullable String hint = req.getParameter("token_type_hint");
        Database db = wr.getDatabase();
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try (Database database = db;){
            tr.begin();
            Permissions perm = new Permissions();
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AuthenticatedInternalCheck())) {
                tr.abort();
                return;
            }
            if ("access_token".equals(hint)) {
                AccessTokenManager.singleton().revoke(token);
            } else if ("refresh_token".equals(hint)) {
                PersistentToken rt = OAuthQuery.getPersistentToken((Database)db, (String)token);
                if (rt != null) {
                    rt.delete(db);
                }
            } else {
                AccessTokenManager.singleton().revoke(token);
                PersistentToken rt = OAuthQuery.getPersistentToken((Database)db, (String)token);
                if (rt != null) {
                    rt.delete(db);
                }
            }
            wr.sendError(501, "Service not implemented");
        }
        catch (DatabaseException ex) {
            tr.abort();
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Unable to revoke token", (Throwable)ex);
            wr.sendError((Exception)((Object)ex));
        }
    }
}

