/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.authorizer;

import com.pageseeder.base.oauth.core.OAuthErrorResponse;
import com.pageseeder.base.oauth.core.OAuthErrorType;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.base.oauth.core.OAuthResponse;
import com.pageseeder.base.oauth.core.ResponseType;
import com.pageseeder.base.oauth.model.CodeManager;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.http.HttpRedirect;
import com.pageseeder.common.oauth.GrantType;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.Scope;
import com.pageseeder.oauth.authorizer.AuthorizationRequest;
import com.pageseeder.oauth.authorizer.AuthorizationResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthorizeServlet
extends HttpServlet {
    private static final long serialVersionUID = -4615653544842778518L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizeServlet.class);
    private @Nullable String oob = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.oob = config.getInitParameter("out-of-band-page");
    }

    public void destroy() {
        super.destroy();
        this.oob = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.authorize(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.authorize(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authorize(HttpServletRequest req, HttpServletResponse res) throws IOException {
        block21: {
            Database db = WebRequest.getDatabase((HttpServletResponse)res);
            if (db == null) {
                return;
            }
            String redirectURI = null;
            Transaction tr = new Transaction(db);
            try {
                tr.begin();
                Permissions perm = new Permissions();
                if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AuthenticatedInternalCheck(), (boolean)false)) {
                    String redirect = GlobalSettings.getSitePrefix() + "/ui/signin.html?location=" + URLEncoder.encode(req.getRequestURI() + "?" + (req.getQueryString() != null ? req.getQueryString() : ""), StandardCharsets.UTF_8);
                    HttpRedirect.sendRedirect((HttpServletRequest)req, (HttpServletResponse)res, (String)redirect);
                    tr.commit();
                    return;
                }
                AuthorizationRequest oauth = AuthorizationRequest.newInstance(req);
                String clientId = oauth.getClientId();
                Client client = OAuthQuery.getClientByIdentifier((Database)db, (String)clientId);
                if (client == null) {
                    throw OAuthException.error((OAuthErrorType)OAuthErrorType.unauthorized_client);
                }
                assert (clientId != null);
                redirectURI = oauth.getRedirectURI();
                if (redirectURI == null) {
                    redirectURI = client.getRedirectURI();
                } else if (redirectURI.isEmpty()) {
                    redirectURI = this.oob;
                } else if (!client.isValidRedirectURI(redirectURI)) {
                    throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_request, (String)"The redirect URI does not match for this client");
                }
                String state = oauth.getState();
                Set scopes = client.getScopes();
                if (oauth.getParameter(OAuthParameter.scope) != null) {
                    scopes = client.filterScopes((Collection)oauth.getScopes());
                }
                Long memberId = perm.getMemberId();
                if (ResponseType.code == oauth.getResponseType() && client.getGrantType() == GrantType.authorization_code) {
                    CodeManager codes = CodeManager.singleton();
                    String code = codes.issue(clientId, redirectURI, memberId.longValue(), Scope.join((String)" ", (Set)scopes));
                    client.updateLastToken();
                    OAuthResponse response = new AuthorizationResponse(302, state).setCode(code).setScope(Scope.join((String)" ", (Set)scopes)).location(redirectURI);
                    tr.commit();
                    response.toQueryMessage(res);
                    break block21;
                }
                OAuthException ex = OAuthException.error((OAuthErrorType)OAuthErrorType.unauthorized_client, (String)"The client is not authorized to request an access token using this method");
                ex.setRedirectURI(redirectURI);
                ex.state(state);
                throw ex;
            }
            catch (OAuthException ex) {
                tr.abort();
                if (ex.getRedirectURI() != null) {
                    OAuthErrorResponse response = new OAuthErrorResponse(302).error(ex).location(ex.getRedirectURI());
                    response.toQueryMessage(res);
                } else {
                    res.sendError(400, String.valueOf(ex.getError()) + ": " + ex.getDescription());
                }
            }
            catch (Exception ex) {
                tr.abort();
                AuthorizeServlet.handleError(res, ex, redirectURI);
            }
            finally {
                db.close();
                db = null;
            }
        }
    }

    private static void handleError(HttpServletResponse res, Exception ex, @Nullable String redirectURI) throws IOException {
        LOGGER.error("Authorization failed due to internal error: {}", (Object)ex.getMessage(), (Object)ex);
        if (redirectURI != null) {
            OAuthException error = OAuthException.error((OAuthErrorType)OAuthErrorType.server_error);
            OAuthErrorResponse response = new OAuthErrorResponse(500).error(error).location(redirectURI);
            response.toQueryMessage(res);
        } else {
            res.sendError(503);
        }
    }
}

