/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.authorizer;

import com.pageseeder.base.oauth.core.OAuthErrorType;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.base.oauth.core.OAuthRequest;
import com.pageseeder.base.oauth.core.OAuthRequestValidator;
import com.pageseeder.base.oauth.core.ResponseType;
import com.pageseeder.common.util.Strings;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;

public final class AuthorizationRequest
extends OAuthRequest {
    private final ResponseType responseType;

    private AuthorizationRequest(HttpServletRequest req, ResponseType responseType) {
        super(req);
        this.responseType = responseType;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public @Nullable String getState() {
        return this.getParameter(OAuthParameter.state);
    }

    public static AuthorizationRequest newInstance(HttpServletRequest req) throws OAuthException {
        String responseType = req.getParameter(OAuthParameter.response_type.name());
        ResponseType type = AuthorizationRequest.toResponseType(responseType);
        OAuthRequestValidator validator = AuthorizationRequest.getValidator(type);
        AuthorizationRequest oauth = new AuthorizationRequest(req, type);
        validator.validate((OAuthRequest)oauth);
        return oauth;
    }

    private static ResponseType toResponseType(String responseType) throws OAuthException {
        if (Strings.isEmpty((String)responseType)) {
            throw OAuthException.newInvalidRequest((String)"Missing response_type parameter value");
        }
        try {
            return ResponseType.valueOf((String)responseType);
        }
        catch (IllegalArgumentException ex) {
            throw OAuthException.error((OAuthErrorType)OAuthErrorType.unsupported_response_type, (String)"Unsupported response_type parameter value");
        }
    }

    private static OAuthRequestValidator getValidator(ResponseType type) {
        OAuthRequestValidator validator = OAuthRequestValidator.create().acceptsMethod(new String[]{"GET", "POST"});
        if (type == ResponseType.code) {
            return validator.requires(new OAuthParameter[]{OAuthParameter.response_type, OAuthParameter.client_id});
        }
        if (type == ResponseType.token) {
            return validator.requires(new OAuthParameter[]{OAuthParameter.response_type, OAuthParameter.client_id, OAuthParameter.redirect_uri});
        }
        throw new IllegalArgumentException();
    }
}

