/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.model.AuthorizationCode;
import com.pageseeder.base.oauth.model.CodeManager;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import java.io.IOException;

@Requires(parameters={"client-identifier", "member-id"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class IssueAuthorizationCode
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (GlobalSettings.getBoolean((String)"manualTokenCreation", (boolean)false)) {
            return new ManageOAuthCheck(req.getHttpServletRequest());
        }
        return new ForbiddenCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String clientId = req.getParameter((Parameter)StandardParameters.client_identifier);
        long memberId = req.getParameter((Parameter)StandardParameters.member_id, -1L);
        String scope = req.getParameter((Parameter)StandardParameters.scope, "");
        assert (clientId != null);
        Database db = req.getDatabase();
        Client client = OAuthQuery.getClientByIdentifier((Database)db, (String)clientId);
        if (client == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid client ID");
            return;
        }
        Member member = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
        if (member == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid member ID");
            return;
        }
        CodeManager manager = CodeManager.singleton();
        try {
            String code = manager.issue(clientId, client.getRedirectURI(), memberId, scope);
            client.updateLastToken();
            AuthorizationCode instance = manager.get(code);
            if (instance != null) {
                res.setStatus(GeneratorStatus.CREATED);
                UniversalPrinter out = res.getUniversalWriter();
                out.startObject("authorization-code-issue");
                out.write((UniversallyPrintable)instance);
                out.writeClient(client);
                out.writeMember(member);
                out.endObject();
                out.flush();
            }
        }
        catch (OAuthException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, ex.getMessage());
        }
    }
}

