/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Member;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, parameters={"email"})
public final class ClearTokensForUser
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageOAuthCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, QueryFailedException {
        Database db = req.getDatabase();
        String email = req.getParameter((Parameter)StandardParameters.email);
        assert (email != null);
        Member mem = DatabaseQuery.getMemberByEmail((Database)db, (String)email);
        int count = mem == null ? 0 : AccessTokenManager.singleton().revokeForMember(mem.getId().longValue());
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("clear-user-tokens");
        xml.attribute("for", email);
        xml.attribute("count", count);
        xml.closeElement();
    }
}

