/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.InsertFailedException;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Helper;
import com.pageseeder.db.oauth.Client;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import javax.jdo.JDOFatalInternalException;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class Webhook
extends DBObject
implements Persistable {
    private Long id;
    private Client client;
    private Date dateCreated;
    private Date dateModified;
    private @Nullable String name;
    private String url;
    private Boolean server;
    private @Nullable String projects;
    private @Nullable String groups;
    private @Nullable String events;
    private ObjectType object;
    private Format format;
    private Boolean insecureSSL;
    private Status status;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = Webhook.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = Webhook.__dnGetInheritedFieldCount();

    @Override
    public Long getId() {
        return Webhook.dnGetid(this);
    }

    public Client getClient() {
        return Webhook.dnGetclient(this);
    }

    public Date getDateCreated() {
        return Webhook.dnGetdateCreated(this);
    }

    public Date getDateModified() {
        return Webhook.dnGetdateModified(this);
    }

    public @Nullable String getEvents() {
        return Webhook.dnGetevents(this);
    }

    public Collection<String> getEventsCol() {
        return Webhook.dnGetevents(this) == null ? Collections.emptyList() : Arrays.asList(Webhook.dnGetevents(this).split(","));
    }

    public void setEvents(@Nullable String events) {
        Webhook.dnSetevents(this, events);
    }

    public @Nullable String getProjects() {
        return Webhook.dnGetprojects(this);
    }

    public Collection<String> getProjectsCol() {
        return Webhook.dnGetprojects(this) == null ? Collections.emptyList() : Arrays.asList(Webhook.dnGetprojects(this).split(","));
    }

    public void setProjects(@Nullable String projects) {
        Webhook.dnSetprojects(this, projects);
    }

    public @Nullable String getGroups() {
        return Webhook.dnGetgroups(this);
    }

    public boolean filterGroups() {
        return Webhook.dnGetgroups(this) != null && !Webhook.dnGetgroups(this).isEmpty();
    }

    public Collection<String> getGroupsCol() {
        return Webhook.dnGetgroups(this) == null ? Collections.emptyList() : Arrays.asList(Webhook.dnGetgroups(this).split(","));
    }

    public void setGroups(@Nullable String groups) {
        Webhook.dnSetgroups(this, groups);
    }

    public Boolean getServer() {
        return Webhook.dnGetserver(this);
    }

    public void setServer(Boolean server) {
        Webhook.dnSetserver(this, Objects.requireNonNull(server));
    }

    public String getURL() {
        return Webhook.dnGeturl(this);
    }

    public void setURL(String url) {
        Webhook.dnSeturl(this, Objects.requireNonNull(url));
    }

    public void setClient(Client client) {
        Webhook.dnSetclient(this, Objects.requireNonNull(client));
    }

    public void setDateCreated(Date dateCreated) {
        Webhook.dnSetdateCreated(this, Objects.requireNonNull(dateCreated));
    }

    public void setDateModified(Date dateModified) {
        Webhook.dnSetdateModified(this, Objects.requireNonNull(dateModified));
    }

    public void setFormat(Format format) {
        Webhook.dnSetformat(this, Objects.requireNonNull(format));
    }

    public void setInsecureSSL(Boolean insecureSSL) {
        Webhook.dnSetinsecureSSL(this, Objects.requireNonNull(insecureSSL));
    }

    public void setName(@Nullable String name) {
        Webhook.dnSetname(this, Helper.ensureNotEmpty(name));
    }

    public void setObject(ObjectType object) {
        Webhook.dnSetobject(this, Objects.requireNonNull(object));
    }

    public void setStatus(Status status) {
        Webhook.dnSetstatus(this, Objects.requireNonNull(status));
    }

    public Format getFormat() {
        return Webhook.dnGetformat(this);
    }

    public Boolean getInsecureSSL() {
        return Webhook.dnGetinsecureSSL(this);
    }

    public @Nullable String getName() {
        return Webhook.dnGetname(this);
    }

    public ObjectType getObject() {
        return Webhook.dnGetobject(this);
    }

    public Status getStatus() {
        return Webhook.dnGetstatus(this);
    }

    public boolean includeEvent(@Nullable String event) {
        if (event == null) {
            return false;
        }
        if (Webhook.dnGetevents(this) == null) {
            return true;
        }
        for (String supported : this.getEventsCol()) {
            if (supported.equals(event)) {
                return true;
            }
            if (!supported.endsWith(".*") || !event.startsWith(supported.replaceFirst("\\*$", ""))) continue;
            return true;
        }
        return false;
    }

    public boolean includeGroup(@Nullable String groupname) {
        if (groupname == null) {
            return false;
        }
        if (Webhook.dnGetgroups(this) == null && Webhook.dnGetprojects(this) == null) {
            return true;
        }
        if (Webhook.dnGetprojects(this) != null) {
            for (String project : Webhook.dnGetprojects(this).split(",")) {
                if (!groupname.equals(project) && !groupname.startsWith(project + "-")) continue;
                return true;
            }
        }
        if (Webhook.dnGetgroups(this) != null) {
            return Arrays.asList(Webhook.dnGetgroups(this).split(",")).contains(groupname);
        }
        return false;
    }

    public void toXMLAttributes(XMLWriter xml) throws IOException {
        if (Webhook.dnGetid(this) != null) {
            xml.attribute("id", Long.toString(Webhook.dnGetid(this)));
        }
        xml.attribute("created", ISO8601.DATETIME.format(Webhook.dnGetdateCreated(this).getTime()));
        xml.attribute("modified", ISO8601.DATETIME.format(Webhook.dnGetdateModified(this).getTime()));
        xml.attribute("url", Webhook.dnGeturl(this));
        xml.attribute("server", Boolean.toString(Webhook.dnGetserver(this)));
        xml.attribute("object", Webhook.dnGetobject(this).toString());
        xml.attribute("format", Webhook.dnGetformat(this).toString());
        xml.attribute("insecuressl", Boolean.toString(Webhook.dnGetinsecureSSL(this)));
        xml.attribute("status", Webhook.dnGetstatus(this).toString());
        if (Webhook.dnGetname(this) != null) {
            xml.attribute("name", Webhook.dnGetname(this));
        }
        if (Webhook.dnGetprojects(this) != null) {
            xml.attribute("projects", Webhook.dnGetprojects(this));
        }
        if (Webhook.dnGetgroups(this) != null) {
            xml.attribute("groups", Webhook.dnGetgroups(this));
        }
        if (Webhook.dnGetevents(this) != null) {
            xml.attribute("events", Webhook.dnGetevents(this));
        }
    }

    public Webhook(Client client, String url) {
        this.dateCreated = null;
        this.dateModified = null;
        this.name = null;
        this.url = null;
        this.server = Boolean.TRUE;
        this.projects = null;
        this.groups = null;
        this.events = null;
        this.object = ObjectType.minimal;
        this.format = Format.xml;
        this.insecureSSL = Boolean.FALSE;
        this.client = Objects.requireNonNull(client);
        this.url = Objects.requireNonNull(url);
        this.dateModified = this.dateCreated = new Date();
    }

    public static Webhook create(Database db, Client client, String url) {
        return new Webhook(client, url);
    }

    @Override
    public Webhook insert(Database db) throws InsertFailedException {
        return (Webhook)super.insert(db);
    }

    static {
        EnhancementHelper.registerClass((Class)Webhook.___dn$loadClass("com.pageseeder.db.model.Webhook"), (Persistable)new Webhook());
    }

    protected Webhook() {
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeObjectField(6, (Object)o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        Webhook result = new Webhook();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        Webhook result = new Webhook();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.client = (Client)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.dateCreated = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.dateModified = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.events = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 4: {
                this.format = (Format)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 5: {
                this.groups = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 6: {
                this.id = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 7: {
                this.insecureSSL = (Boolean)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 8: {
                this.name = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 9: {
                this.object = (ObjectType)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 10: {
                this.projects = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 11: {
                this.server = (Boolean)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 12: {
                this.status = (Status)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 13: {
                this.url = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.client);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.dateCreated);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.dateModified);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.events);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.format);
                break;
            }
            case 5: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.groups);
                break;
            }
            case 6: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.id);
                break;
            }
            case 7: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.insecureSSL);
                break;
            }
            case 8: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.name);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.object);
                break;
            }
            case 10: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.projects);
                break;
            }
            case 11: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.server);
                break;
            }
            case 12: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.status);
                break;
            }
            case 13: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.url);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(Webhook obj, int index) {
        switch (index) {
            case 0: {
                this.client = obj.client;
                break;
            }
            case 1: {
                this.dateCreated = obj.dateCreated;
                break;
            }
            case 2: {
                this.dateModified = obj.dateModified;
                break;
            }
            case 3: {
                this.events = obj.events;
                break;
            }
            case 4: {
                this.format = obj.format;
                break;
            }
            case 5: {
                this.groups = obj.groups;
                break;
            }
            case 6: {
                this.id = obj.id;
                break;
            }
            case 7: {
                this.insecureSSL = obj.insecureSSL;
                break;
            }
            case 8: {
                this.name = obj.name;
                break;
            }
            case 9: {
                this.object = obj.object;
                break;
            }
            case 10: {
                this.projects = obj.projects;
                break;
            }
            case 11: {
                this.server = obj.server;
                break;
            }
            case 12: {
                this.status = obj.status;
                break;
            }
            case 13: {
                this.url = obj.url;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Webhook)) {
            throw new IllegalArgumentException("object is not an object of type com.pageseeder.db.model.Webhook");
        }
        Webhook other = (Webhook)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"client", "dateCreated", "dateModified", "events", "format", "groups", "id", "insecureSSL", "name", "object", "projects", "server", "status", "url"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 14;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static Client dnGetclient(Webhook objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (Client)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, (Object)objPC.client);
        }
        return objPC.client;
    }

    private static void dnSetclient(Webhook objPC, Client val) {
        if (objPC.dnStateManager == null) {
            objPC.client = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, (Object)objPC.client, (Object)val);
        }
    }

    private static Date dnGetdateCreated(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 1, (Object)objPC.dateCreated);
        }
        return objPC.dateCreated;
    }

    private static void dnSetdateCreated(Webhook objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1, (Object)objPC.dateCreated, (Object)val);
        } else {
            objPC.dateCreated = val;
        }
    }

    private static Date dnGetdateModified(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, (Object)objPC.dateModified);
        }
        return objPC.dateModified;
    }

    private static void dnSetdateModified(Webhook objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, (Object)objPC.dateModified, (Object)val);
        } else {
            objPC.dateModified = val;
        }
    }

    private static String dnGetevents(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3, objPC.events);
        }
        return objPC.events;
    }

    private static void dnSetevents(Webhook objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3, objPC.events, val);
        } else {
            objPC.events = val;
        }
    }

    private static Format dnGetformat(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return (Format)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 4, (Object)objPC.format));
        }
        return objPC.format;
    }

    private static void dnSetformat(Webhook objPC, Format val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4, (Object)objPC.format, (Object)val);
        } else {
            objPC.format = val;
        }
    }

    private static String dnGetgroups(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 5, objPC.groups);
        }
        return objPC.groups;
    }

    private static void dnSetgroups(Webhook objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 5, objPC.groups, val);
        } else {
            objPC.groups = val;
        }
    }

    private static Long dnGetid(Webhook objPC) {
        return objPC.id;
    }

    private static void dnSetid(Webhook objPC, Long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 6, (Object)objPC.id, (Object)val);
        }
    }

    private static Boolean dnGetinsecureSSL(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return (Boolean)objPC.dnStateManager.getObjectField((Persistable)objPC, 7, (Object)objPC.insecureSSL);
        }
        return objPC.insecureSSL;
    }

    private static void dnSetinsecureSSL(Webhook objPC, Boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 7, (Object)objPC.insecureSSL, (Object)val);
        } else {
            objPC.insecureSSL = val;
        }
    }

    private static String dnGetname(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 8, objPC.name);
        }
        return objPC.name;
    }

    private static void dnSetname(Webhook objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 8, objPC.name, val);
        } else {
            objPC.name = val;
        }
    }

    private static ObjectType dnGetobject(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9)) {
            return (ObjectType)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 9, (Object)objPC.object));
        }
        return objPC.object;
    }

    private static void dnSetobject(Webhook objPC, ObjectType val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9, (Object)objPC.object, (Object)val);
        } else {
            objPC.object = val;
        }
    }

    private static String dnGetprojects(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 10)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 10, objPC.projects);
        }
        return objPC.projects;
    }

    private static void dnSetprojects(Webhook objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 10, objPC.projects, val);
        } else {
            objPC.projects = val;
        }
    }

    private static Boolean dnGetserver(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 11)) {
            return (Boolean)objPC.dnStateManager.getObjectField((Persistable)objPC, 11, (Object)objPC.server);
        }
        return objPC.server;
    }

    private static void dnSetserver(Webhook objPC, Boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 11, (Object)objPC.server, (Object)val);
        } else {
            objPC.server = val;
        }
    }

    private static Status dnGetstatus(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 12)) {
            return (Status)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 12, (Object)objPC.status));
        }
        return objPC.status;
    }

    private static void dnSetstatus(Webhook objPC, Status val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 12, (Object)objPC.status, (Object)val);
        } else {
            objPC.status = val;
        }
    }

    private static String dnGeturl(Webhook objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 13)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 13, objPC.url);
        }
        return objPC.url;
    }

    private static void dnSeturl(Webhook objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 13, objPC.url, val);
        } else {
            objPC.url = val;
        }
    }

    public static enum ObjectType {
        minimal,
        basic;


        public static @Nullable ObjectType fromString(String s) {
            for (ObjectType v : ObjectType.values()) {
                if (!v.name().equals(s)) continue;
                return v;
            }
            return null;
        }
    }

    public static enum Format {
        xml,
        json;


        public static @Nullable Format fromString(String s) {
            for (Format v : Format.values()) {
                if (!v.name().equals(s)) continue;
                return v;
            }
            return null;
        }
    }

    public static enum Status {
        pending,
        active,
        disabled,
        warning,
        error,
        unreachable;


        public static @Nullable Status fromString(String s) {
            for (Status v : Status.values()) {
                if (!v.name().equals(s)) continue;
                return v;
            }
            return null;
        }
    }
}

