/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.util.Rules;
import com.pageseeder.db.CreateFailedException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.InsertFailedException;
import com.pageseeder.db.PSQuery;
import com.pageseeder.db.Predicate;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Helper;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOFatalInternalException;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URI
extends DBObject
implements Persistable {
    private static final String BINARY_MEDIA_TYPE = "application/octet-stream";
    private static final String PSML_MEDIA_TYPE = "application/vnd.pageseeder.psml+xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(URI.class);
    private @Nullable String docID;
    private @Nullable String scheme;
    private String path;
    private String parentPath;
    private Collection<GroupURI> groupURIs = new HashSet<GroupURI>();
    private Collection<Locator> locators = new HashSet<Locator>();
    private Integer port;
    private Host host;
    private @Nullable String labels;
    private @Nullable Long size;
    private Boolean archived;
    private @Nullable Boolean folder;
    private @Nullable String behavior;
    private @Nullable Date lastModified;
    private @Nullable String description;
    private Date dateCreated;
    private @Nullable Date dateArchived;
    private XLink xlink;
    private XLink draftEdit;
    private @Nullable String userTitle;
    private String type;
    private @Nullable byte[] pathHash;
    private Long id;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = URI.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = URI.__dnGetInheritedFieldCount();

    @Override
    public final Long getId() {
        return URI.dnGetid(this);
    }

    public static URI create(Database db) throws CreateFailedException {
        URI uri = new URI();
        uri.setDateCreated(new Date());
        return uri;
    }

    @Override
    public final URI insert(Database db) throws InsertFailedException {
        return (URI)super.insert(db);
    }

    public final @Nullable String getDocID() {
        return URI.dnGetdocID(this);
    }

    public final Boolean getArchived() {
        return URI.dnGetarchived(this);
    }

    public final boolean isArchived() {
        return URI.dnGetarchived(this) == Boolean.TRUE;
    }

    public final Boolean getFolder() {
        return URI.dnGetfolder(this);
    }

    public final boolean isFolder() {
        return URI.dnGetfolder(this) == Boolean.TRUE;
    }

    public final @Nullable Long getSize() {
        return URI.dnGetsize(this);
    }

    public final String getScheme() {
        return URI.dnGetscheme(this);
    }

    public final String getDecodedPath() {
        return URLCoder.decode((String)URI.dnGetpath(this));
    }

    public final @Nullable String getLabels() {
        if (URI.dnGetlabels(this) != null) {
            return URI.dnGetlabels(this).endsWith(",") ? URI.dnGetlabels(this).substring(0, URI.dnGetlabels(this).length() - 1) : URI.dnGetlabels(this);
        }
        return null;
    }

    public final void setLabels(@Nullable String labels) {
        URI.dnSetlabels(this, labels);
    }

    public final String getPath() {
        return Rules.uriDBPathToEncodedPath((String)URI.dnGetpath(this));
    }

    public final String getParentPath() {
        return Rules.uriDBPathToEncodedPath((String)URI.dnGetparentPath(this));
    }

    public final Integer getPort() {
        return URI.dnGetport(this);
    }

    public final @Nullable String getBehavior() {
        return URI.dnGetbehavior(this);
    }

    public final Date getLastModified() {
        if (URI.dnGetlastModified(this) == null) {
            return URI.dnGetdateCreated(this);
        }
        return URI.dnGetlastModified(this);
    }

    public final @Nullable String getDescription() {
        return URI.dnGetdescription(this);
    }

    public final Date getDateCreated() {
        return URI.dnGetdateCreated(this);
    }

    public final @Nullable Date getDateArchived() {
        return URI.dnGetdateArchived(this);
    }

    public final @Nullable String getUserTitle() {
        return URI.dnGetuserTitle(this);
    }

    public final String getDisplayTitle() {
        if (URI.dnGetuserTitle(this) != null && !URI.dnGetuserTitle(this).trim().isEmpty()) {
            return URI.dnGetuserTitle(this);
        }
        if (URIs.isExternal(this)) {
            return URLCoder.decode((String)URIs.getURIString(this));
        }
        String apath = this.getDecodedPath();
        if (apath.indexOf(47) == -1) {
            return apath;
        }
        return apath.substring(apath.lastIndexOf(47) + 1);
    }

    public final String getType() {
        return URI.dnGettype(this);
    }

    public final void setPort(Integer newPort) {
        URI.dnSetport(this, newPort);
    }

    public final void setSize(Long newsize) {
        URI.dnSetsize(this, newsize);
    }

    public final void setArchived(Boolean isArchived) {
        URI.dnSetarchived(this, isArchived);
    }

    public final void setFolder(@Nullable Boolean isFolder) {
        URI.dnSetfolder(this, isFolder);
    }

    public final void setDateCreated(Date newDateCreated) {
        URI.dnSetdateCreated(this, newDateCreated);
    }

    public final void setDateArchived(@Nullable Date newDateArchived) {
        URI.dnSetdateArchived(this, newDateArchived);
    }

    public final void setDocID(@Nullable String docID) {
        URI.dnSetdocID(this, Helper.ensureNotEmpty(docID));
    }

    public final void setScheme(String newScheme) {
        URI.dnSetscheme(this, Helper.ensureNotEmpty(newScheme));
    }

    public final void setPath(@Nullable String newPath) {
        if (newPath == null || newPath.isEmpty()) {
            URI.dnSetpath(this, "/");
        } else {
            URI.dnSetpath(this, Rules.uriEncodedPathToDBPath((String)newPath));
        }
        int i = URI.dnGetpath(this).lastIndexOf(47);
        if (i != -1) {
            URI.dnSetparentPath(this, URI.dnGetpath(this).substring(0, i));
        } else {
            URI.dnSetparentPath(this, URI.dnGetpath(this));
        }
        if (URIs.isExternal(this)) {
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException("Failed to generate path hash", ex);
            }
            URI.dnSetpathHash(this, md.digest(URI.dnGetpath(this).getBytes(StandardCharsets.US_ASCII)));
        } else {
            URI.dnSetpathHash(this, new byte[]{0});
        }
    }

    public final void setBehavior(@Nullable String newBehavior) {
        URI.dnSetbehavior(this, Helper.ensureNotEmpty(newBehavior));
    }

    public final void setLastModified(Date newLastModified) {
        URI.dnSetlastModified(this, newLastModified);
    }

    public final void setDescription(String description) {
        URI.dnSetdescription(this, Helper.ensureNotEmpty(description));
    }

    public final void setUserTitle(String userTitle) {
        URI.dnSetuserTitle(this, Helper.ensureNotEmpty(userTitle));
    }

    public final void setType(String newType) {
        if (BINARY_MEDIA_TYPE.equals(newType) && URI.dnGetpath(this) != null && URI.dnGetpath(this).toLowerCase().endsWith(".psml")) {
            LOGGER.warn("Setting media type of URI {} to {} instead of {}", new Object[]{URI.dnGetpath(this), PSML_MEDIA_TYPE, BINARY_MEDIA_TYPE});
            newType = PSML_MEDIA_TYPE;
        }
        URI.dnSettype(this, Helper.ensureNotEmpty(newType));
        if ("folder".equals(newType)) {
            URI.dnSetfolder(this, Boolean.TRUE);
        }
    }

    public final Host getHost() {
        return URI.dnGethost(this);
    }

    public final @Nullable XLink getXLink() {
        return URI.dnGetxlink(this);
    }

    public final XLink getDraftEdit() {
        return URI.dnGetdraftEdit(this);
    }

    public final void setHost(Host newhost) {
        URI.dnSethost(this, newhost);
    }

    public final void setDraftEdit(XLink newXLink) {
        URI.dnSetdraftEdit(this, newXLink);
    }

    public final void setXLink(XLink newXLink) {
        URI.dnSetxlink(this, newXLink);
    }

    public final Boolean getExternal() {
        return URIs.isExternal(this);
    }

    public final boolean isExternal() {
        return URIs.isExternal(this);
    }

    public final Iterator<GroupURI> getGroupURIs() {
        return this.getGroupURIsCol().iterator();
    }

    public final Iterator<Locator> getLocators() {
        return this.getLocatorsCol().iterator();
    }

    public final Iterator<GroupURI> getGroupURIs(Object predicate) {
        return this.getGroupURIsCol(predicate).iterator();
    }

    public final Iterator<Locator> getLocators(Object predicate) {
        return this.getLocatorsCol(predicate).iterator();
    }

    public final Collection<GroupURI> getGroupURIsCol() {
        return new ArrayList<GroupURI>(URI.dnGetgroupURIs(this));
    }

    public final Collection<Locator> getLocatorsCol() {
        return new ArrayList<Locator>(URI.dnGetlocators(this));
    }

    public final Collection<GroupURI> getGroupURIsCol(Object predicate) {
        if (!(predicate instanceof Predicate)) {
            return URI.dnGetgroupURIs(this);
        }
        Predicate pred = (Predicate)predicate;
        if (pred.getClause() == null) {
            return URI.dnGetgroupURIs(this);
        }
        try {
            PSQuery pq = new PSQuery(GroupURI.class, "u.groupURIs.contains(this)", predicate);
            pq.addParameter("com.pageseeder.db.model.URI u", this);
            return pq.execute();
        }
        catch (QueryFailedException e) {
            DatabaseQuery.logDatabaseException(e);
            return null;
        }
    }

    public final List<Locator> getLocatorsList(Object predicate) {
        try {
            PSQuery pq = new PSQuery(Locator.class, "this.uri.id == uriid", predicate);
            pq.addParameter("long uriid", this.getId());
            return pq.execute();
        }
        catch (QueryFailedException e) {
            DatabaseQuery.logDatabaseException(e);
            return null;
        }
    }

    public final Collection<Locator> getLocatorsCol(Object predicate) {
        return this.getLocatorsList(predicate);
    }

    public final void addGroupURIs(GroupURI newGroupURIs) {
        URI.dnGetgroupURIs(this).add(newGroupURIs);
    }

    public final void addLocators(Locator newLocators) {
        URI.dnGetlocators(this).add(newLocators);
    }

    public final void removeGroupURIs(GroupURI oldGroupURIs) {
        URI.dnGetgroupURIs(this).remove(oldGroupURIs);
    }

    public final void removeLocators(Locator oldLocators) {
        URI.dnGetlocators(this).remove(oldLocators);
    }

    public String toString() {
        return "uri:" + URI.dnGetid(this) + " (" + URI.dnGetpath(this) + ")";
    }

    static {
        EnhancementHelper.registerClass((Class)URI.___dn$loadClass("com.pageseeder.db.model.URI"), (Persistable)new URI());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeObjectField(10, (Object)o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        URI result = new URI();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        URI result = new URI();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.archived = (Boolean)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.behavior = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.dateArchived = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.dateCreated = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.description = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 5: {
                this.docID = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 6: {
                this.draftEdit = (XLink)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 7: {
                this.folder = (Boolean)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 8: {
                this.groupURIs = (Collection)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 9: {
                this.host = (Host)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 10: {
                this.id = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 11: {
                this.labels = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 12: {
                this.lastModified = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 13: {
                this.locators = (Collection)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 14: {
                this.parentPath = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 15: {
                this.path = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 16: {
                this.pathHash = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 17: {
                this.port = (Integer)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 18: {
                this.scheme = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 19: {
                this.size = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 20: {
                this.type = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 21: {
                this.userTitle = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 22: {
                this.xlink = (XLink)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.archived);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.behavior);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.dateArchived);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.dateCreated);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.description);
                break;
            }
            case 5: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.docID);
                break;
            }
            case 6: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.draftEdit);
                break;
            }
            case 7: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.folder);
                break;
            }
            case 8: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.groupURIs);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.host);
                break;
            }
            case 10: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.id);
                break;
            }
            case 11: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.labels);
                break;
            }
            case 12: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.lastModified);
                break;
            }
            case 13: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.locators);
                break;
            }
            case 14: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.parentPath);
                break;
            }
            case 15: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.path);
                break;
            }
            case 16: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.pathHash);
                break;
            }
            case 17: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.port);
                break;
            }
            case 18: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.scheme);
                break;
            }
            case 19: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.size);
                break;
            }
            case 20: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.type);
                break;
            }
            case 21: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.userTitle);
                break;
            }
            case 22: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.xlink);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(URI obj, int index) {
        switch (index) {
            case 0: {
                this.archived = obj.archived;
                break;
            }
            case 1: {
                this.behavior = obj.behavior;
                break;
            }
            case 2: {
                this.dateArchived = obj.dateArchived;
                break;
            }
            case 3: {
                this.dateCreated = obj.dateCreated;
                break;
            }
            case 4: {
                this.description = obj.description;
                break;
            }
            case 5: {
                this.docID = obj.docID;
                break;
            }
            case 6: {
                this.draftEdit = obj.draftEdit;
                break;
            }
            case 7: {
                this.folder = obj.folder;
                break;
            }
            case 8: {
                this.groupURIs = obj.groupURIs;
                break;
            }
            case 9: {
                this.host = obj.host;
                break;
            }
            case 10: {
                this.id = obj.id;
                break;
            }
            case 11: {
                this.labels = obj.labels;
                break;
            }
            case 12: {
                this.lastModified = obj.lastModified;
                break;
            }
            case 13: {
                this.locators = obj.locators;
                break;
            }
            case 14: {
                this.parentPath = obj.parentPath;
                break;
            }
            case 15: {
                this.path = obj.path;
                break;
            }
            case 16: {
                this.pathHash = obj.pathHash;
                break;
            }
            case 17: {
                this.port = obj.port;
                break;
            }
            case 18: {
                this.scheme = obj.scheme;
                break;
            }
            case 19: {
                this.size = obj.size;
                break;
            }
            case 20: {
                this.type = obj.type;
                break;
            }
            case 21: {
                this.userTitle = obj.userTitle;
                break;
            }
            case 22: {
                this.xlink = obj.xlink;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof URI)) {
            throw new IllegalArgumentException("object is not an object of type com.pageseeder.db.model.URI");
        }
        URI other = (URI)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"archived", "behavior", "dateArchived", "dateCreated", "description", "docID", "draftEdit", "folder", "groupURIs", "host", "id", "labels", "lastModified", "locators", "parentPath", "path", "pathHash", "port", "scheme", "size", "type", "userTitle", "xlink"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 23;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static Boolean dnGetarchived(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (Boolean)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, (Object)objPC.archived);
        }
        return objPC.archived;
    }

    private static void dnSetarchived(URI objPC, Boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, (Object)objPC.archived, (Object)val);
        } else {
            objPC.archived = val;
        }
    }

    private static String dnGetbehavior(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.behavior);
        }
        return objPC.behavior;
    }

    private static void dnSetbehavior(URI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.behavior, val);
        } else {
            objPC.behavior = val;
        }
    }

    private static Date dnGetdateArchived(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, (Object)objPC.dateArchived);
        }
        return objPC.dateArchived;
    }

    private static void dnSetdateArchived(URI objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, (Object)objPC.dateArchived, (Object)val);
        } else {
            objPC.dateArchived = val;
        }
    }

    private static Date dnGetdateCreated(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 3, (Object)objPC.dateCreated);
        }
        return objPC.dateCreated;
    }

    private static void dnSetdateCreated(URI objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, (Object)objPC.dateCreated, (Object)val);
        } else {
            objPC.dateCreated = val;
        }
    }

    private static String dnGetdescription(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4, objPC.description);
        }
        return objPC.description;
    }

    private static void dnSetdescription(URI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4, objPC.description, val);
        } else {
            objPC.description = val;
        }
    }

    private static String dnGetdocID(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 5, objPC.docID);
        }
        return objPC.docID;
    }

    private static void dnSetdocID(URI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 5, objPC.docID, val);
        } else {
            objPC.docID = val;
        }
    }

    private static XLink dnGetdraftEdit(URI objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return (XLink)objPC.dnStateManager.getObjectField((Persistable)objPC, 6, (Object)objPC.draftEdit);
        }
        return objPC.draftEdit;
    }

    private static void dnSetdraftEdit(URI objPC, XLink val) {
        if (objPC.dnStateManager == null) {
            objPC.draftEdit = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 6, (Object)objPC.draftEdit, (Object)val);
        }
    }

    private static Boolean dnGetfolder(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return (Boolean)objPC.dnStateManager.getObjectField((Persistable)objPC, 7, (Object)objPC.folder);
        }
        return objPC.folder;
    }

    private static void dnSetfolder(URI objPC, Boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 7, (Object)objPC.folder, (Object)val);
        } else {
            objPC.folder = val;
        }
    }

    private static Collection dnGetgroupURIs(URI objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8)) {
            return (Collection)objPC.dnStateManager.getObjectField((Persistable)objPC, 8, objPC.groupURIs);
        }
        return objPC.groupURIs;
    }

    private static void dnSetgroupURIs(URI objPC, Collection val) {
        if (objPC.dnStateManager == null) {
            objPC.groupURIs = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 8, objPC.groupURIs, (Object)val);
        }
    }

    private static Host dnGethost(URI objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9)) {
            return (Host)objPC.dnStateManager.getObjectField((Persistable)objPC, 9, (Object)objPC.host);
        }
        return objPC.host;
    }

    private static void dnSethost(URI objPC, Host val) {
        if (objPC.dnStateManager == null) {
            objPC.host = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9, (Object)objPC.host, (Object)val);
        }
    }

    private static Long dnGetid(URI objPC) {
        return objPC.id;
    }

    private static void dnSetid(URI objPC, Long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 10, (Object)objPC.id, (Object)val);
        }
    }

    private static String dnGetlabels(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 11)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 11, objPC.labels);
        }
        return objPC.labels;
    }

    private static void dnSetlabels(URI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 11, objPC.labels, val);
        } else {
            objPC.labels = val;
        }
    }

    private static Date dnGetlastModified(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 12)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 12, (Object)objPC.lastModified);
        }
        return objPC.lastModified;
    }

    private static void dnSetlastModified(URI objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 12, (Object)objPC.lastModified, (Object)val);
        } else {
            objPC.lastModified = val;
        }
    }

    private static Collection dnGetlocators(URI objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 13)) {
            return (Collection)objPC.dnStateManager.getObjectField((Persistable)objPC, 13, objPC.locators);
        }
        return objPC.locators;
    }

    private static void dnSetlocators(URI objPC, Collection val) {
        if (objPC.dnStateManager == null) {
            objPC.locators = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 13, objPC.locators, (Object)val);
        }
    }

    private static String dnGetparentPath(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 14)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 14, objPC.parentPath);
        }
        return objPC.parentPath;
    }

    private static void dnSetparentPath(URI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 14, objPC.parentPath, val);
        } else {
            objPC.parentPath = val;
        }
    }

    private static String dnGetpath(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 15)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 15, objPC.path);
        }
        return objPC.path;
    }

    private static void dnSetpath(URI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 15, objPC.path, val);
        } else {
            objPC.path = val;
        }
    }

    private static byte[] dnGetpathHash(URI objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 16)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 16, (Object)objPC.pathHash);
        }
        return objPC.pathHash;
    }

    private static void dnSetpathHash(URI objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.pathHash = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 16, (Object)objPC.pathHash, (Object)val);
        }
    }

    private static Integer dnGetport(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 17)) {
            return (Integer)objPC.dnStateManager.getObjectField((Persistable)objPC, 17, (Object)objPC.port);
        }
        return objPC.port;
    }

    private static void dnSetport(URI objPC, Integer val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 17, (Object)objPC.port, (Object)val);
        } else {
            objPC.port = val;
        }
    }

    private static String dnGetscheme(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 18)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 18, objPC.scheme);
        }
        return objPC.scheme;
    }

    private static void dnSetscheme(URI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 18, objPC.scheme, val);
        } else {
            objPC.scheme = val;
        }
    }

    private static Long dnGetsize(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 19)) {
            return (Long)objPC.dnStateManager.getObjectField((Persistable)objPC, 19, (Object)objPC.size);
        }
        return objPC.size;
    }

    private static void dnSetsize(URI objPC, Long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 19, (Object)objPC.size, (Object)val);
        } else {
            objPC.size = val;
        }
    }

    private static String dnGettype(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 20)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 20, objPC.type);
        }
        return objPC.type;
    }

    private static void dnSettype(URI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 20, objPC.type, val);
        } else {
            objPC.type = val;
        }
    }

    private static String dnGetuserTitle(URI objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 21)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 21, objPC.userTitle);
        }
        return objPC.userTitle;
    }

    private static void dnSetuserTitle(URI objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 21, objPC.userTitle, val);
        } else {
            objPC.userTitle = val;
        }
    }

    private static XLink dnGetxlink(URI objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 22)) {
            return (XLink)objPC.dnStateManager.getObjectField((Persistable)objPC, 22, (Object)objPC.xlink);
        }
        return objPC.xlink;
    }

    private static void dnSetxlink(URI objPC, XLink val) {
        if (objPC.dnStateManager == null) {
            objPC.xlink = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 22, (Object)objPC.xlink, (Object)val);
        }
    }
}

