/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db;

import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.eclipse.jdt.annotation.Nullable;

public final class Predicates {
    private Predicates() {
    }

    public static Predicate predicateMemberForGroupByGroups(Database db, @Nullable Collection<String> groups) {
        Predicate p = new Predicate(db);
        if (groups == null || groups.isEmpty()) {
            return p;
        }
        StringBuilder clause = new StringBuilder();
        boolean first = true;
        for (String gn : groups) {
            String unique = Predicates.unique("gns", gn);
            p.addParam("String " + unique, gn);
            if (!first) {
                clause.append(" || ");
            }
            clause.append(unique + " == this.group.name");
            first = false;
        }
        p.setClause(clause.toString());
        return p;
    }

    public static Predicate predicateGroupsForXLinkByGroups(Database db, @Nullable Collection<String> groups) {
        if (groups == null) {
            groups = Collections.emptyList();
        }
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("gns", groups);
        p.setClause(unique + ".contains(this.group.name) || this.group.flags.indexOf('p') != -1");
        p.addParam("java.util.Collection " + unique, groups);
        return p;
    }

    public static Predicate predicateOrderBy(Database db, String orderBy) {
        Predicate p = new Predicate(db);
        p.setOrdering("this." + orderBy);
        return p;
    }

    public static Predicate predicateLocatorFragment(Database db, String locfrag) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("frag", locfrag);
        p.setClause("this.fragment" + DatabaseQuery.lowerCase() + " == " + unique);
        p.addParam("java.lang.String " + unique, locfrag.toLowerCase());
        return p;
    }

    public static Predicate predicateMemberForGroupRegistered(Database db, boolean archived) {
        Predicate pred = new Predicate(db);
        pred.setClause("(this.editorFlags == null || this.editorFlags.indexOf('d') == -1)" + (archived ? "" : "  && (this.group.flags == null || this.group.flags.indexOf('d') == -1)"));
        return pred;
    }

    public static Predicate predicateMemberForGroupEditorFlagsContain(Database db, String containValue, boolean contain) {
        Predicate pred = new Predicate(db);
        String unique = Predicates.unique("contains", containValue);
        if (contain) {
            pred.setClause("(this.editorFlags != null && this.editorFlags.indexOf(" + unique + ") != -1)");
        } else {
            pred.setClause("(this.editorFlags == null || this.editorFlags.indexOf(" + unique + ") == -1)");
        }
        pred.addParam("java.lang.String " + unique, containValue);
        return pred;
    }

    public static Predicate predicateXLinkForLocatorAuthorEmailDateAfter(Database db, String authemail, @Nullable Date date) {
        Predicate p = new Predicate(db);
        p.setClause("(this.xlink.authorEmail == theemail || this.xlink.member.email == theemail)" + (date == null ? "" : " && this.xlink.date > thedate"));
        p.addParam("java.lang.String theemail", authemail);
        if (date != null) {
            p.addParam("java.util.Date thedate", date);
        }
        return p;
    }

    public static Predicate predicateLocatorForXLinkByGroupContentrolesAndNotStatuses(Database db, Long groupid, String @Nullable [] croles, String @Nullable [] notstatuses) {
        int i;
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("groupid", groupid);
        String clause = "this.xlink.groupsForXLink.contains(gfx) && gfx.group.id == " + unique + " && !this.xlink.contentTitle.startsWith('Share')";
        p.addVariable("com.pageseeder.db.model.GroupForXLink gfx");
        p.addParam("java.lang.Long " + unique, groupid);
        if (croles != null && croles.length > 0) {
            clause = clause + " && (";
            for (i = 0; i < croles.length; ++i) {
                unique = Predicates.unique("crole", croles[i]);
                if (i > 0) {
                    clause = clause + " || ";
                }
                clause = clause + "this.xlink.contentRole == " + unique;
                p.addParam("java.lang.String " + unique, croles[i]);
            }
            clause = clause + ")";
        }
        if (notstatuses != null && notstatuses.length > 0) {
            clause = clause + " && (this.xlink.status == null || (";
            for (i = 0; i < notstatuses.length; ++i) {
                unique = Predicates.unique("notstatuses", notstatuses[i]);
                if (i > 0) {
                    clause = clause + " && ";
                }
                clause = clause + "this.xlink.status != " + unique;
                p.addParam("java.lang.String " + unique, notstatuses[i]);
            }
            clause = clause + "))";
        }
        p.setClause(clause);
        return p;
    }

    public static Predicate predicateLocatorForXLinkByContentrolesDescending(Database db, String @Nullable [] croles) {
        Predicate p = new Predicate(db);
        Object clause = "";
        if (croles != null && croles.length > 0) {
            for (int i = 0; i < croles.length; ++i) {
                String unique = Predicates.unique("crole", croles[i]);
                if (i > 0) {
                    clause = (String)clause + " || ";
                }
                clause = (String)clause + "this.xlink.contentRole == " + unique;
                p.addParam("java.lang.String " + unique, croles[i]);
            }
        }
        p.setClause((String)clause);
        p.setOrdering("this.id descending");
        return p;
    }

    public static Predicate predicateLocatorForXLinkByContentRoleEquals(Database db, String contentRole, boolean eq) {
        Predicate p = new Predicate(db);
        String unique1 = Predicates.unique("role", contentRole);
        p.setClause("this.xlink.contentRole " + (eq ? (char)'=' : '!') + "= " + unique1 + " && (this.xlink.properties == null || this.xlink.properties.indexOf('version=') == -1)");
        p.addParam("java.lang.String " + unique1, contentRole);
        p.setOrdering("this.id descending");
        return p;
    }

    public static Predicate predicateXLinkForLocatorContentRoleLike(Database db, String @Nullable [] contentrole) {
        return Predicates.predicateXLinkForLocatorStatusContentRoleLike(db, null, false, contentrole);
    }

    public static Predicate predicateXLinkForLocatorStatusContentRoleLike(Database db, @Nullable String status, boolean statusEquals, String @Nullable [] contentrole) {
        return Predicates.predicateXLinkForLocatorStatusContentRoleLikeDates(db, status, statusEquals, contentrole, null, null);
    }

    public static Predicate predicateXLinkForLocatorStatusContentRoleLikeDates(Database db, @Nullable String status, boolean statusEquals, String @Nullable [] contentrole, @Nullable Date before, @Nullable Date after) {
        String unique;
        Predicate p = new Predicate(db);
        Object clause = "";
        if (status != null) {
            unique = Predicates.unique("status", status);
            p.addParam("java.lang.String " + unique, status);
            clause = (String)clause + "(" + (statusEquals ? "this.xlink.status == " + unique : "this.xlink.status == null || this.xlink.status != " + unique) + ")";
        }
        if (contentrole != null && contentrole.length > 0) {
            Object sclause = "";
            for (int i = 0; i < contentrole.length; ++i) {
                if (i != 0) {
                    sclause = (String)sclause + " || ";
                }
                String unique2 = Predicates.unique("role", contentrole, i);
                if (!contentrole[i].endsWith("%")) {
                    sclause = (String)sclause + "this.xlink.contentRole == " + unique2;
                    p.addParam("java.lang.String " + unique2, contentrole[i]);
                    continue;
                }
                String value = contentrole[i].replaceFirst("%$", "");
                p.addParam("java.lang.String " + unique2, value);
                sclause = (String)sclause + "this.xlink.contentRole.substring(0, " + value.length() + ") == " + unique2;
            }
            if (((String)sclause).length() > 0) {
                if (((String)clause).length() > 0) {
                    clause = (String)clause + " && ";
                }
                clause = (String)clause + "(" + (String)sclause + ")";
            }
        }
        if (before != null) {
            unique = Predicates.unique("before", before.getTime());
            if (((String)clause).length() > 0) {
                clause = (String)clause + " && ";
            }
            clause = (String)clause + "this.xlink.date < " + unique;
            p.addParam("java.util.Date " + unique, before);
        }
        if (after != null) {
            unique = Predicates.unique("after", after.getTime());
            if (((String)clause).length() > 0) {
                clause = (String)clause + " && ";
            }
            clause = (String)clause + "this.xlink.date > " + unique;
            p.addParam("java.util.Date " + unique, after);
        }
        if (((String)clause).length() > 0) {
            p.setClause((String)clause);
        }
        return p;
    }

    public static Predicate predicateXLinkForLocatorByGroupStatusContentRoleLike(Database db, Long groupid, String status, boolean statusEquals, String[] contentrole) {
        return Predicates.predicateXLinkForLocatorByGroupStatusContentRoleLikeDates(db, groupid, status, statusEquals, contentrole, null, null);
    }

    public static Predicate predicateXLinkForLocatorByGroupStatusContentRoleLikeDates(Database db, Long groupid, @Nullable String status, boolean statusEquals, String @Nullable [] contentrole, @Nullable Date before, @Nullable Date after) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("groupid", groupid);
        String clause = "this.xlink.groupsForXLink.contains(gfx) && gfx.group.id == " + unique;
        p.addVariable("com.pageseeder.db.model.GroupForXLink gfx");
        p.addParam("java.lang.Long " + unique, groupid);
        if (status != null) {
            unique = Predicates.unique("status", status);
            p.addParam("java.lang.String " + unique, status);
            clause = clause + " && (" + (statusEquals ? "this.xlink.status == " + unique : "this.xlink.status == null || this.xlink.status != " + unique) + ")";
        }
        if (contentrole != null && contentrole.length > 0) {
            Object sclause = "";
            for (int i = 0; i < contentrole.length; ++i) {
                if (i != 0) {
                    sclause = (String)sclause + " || ";
                }
                unique = Predicates.unique("role", contentrole, i);
                if (!contentrole[i].endsWith("%")) {
                    sclause = (String)sclause + "this.xlink.contentRole == " + unique;
                    p.addParam("java.lang.String " + unique, contentrole[i]);
                    continue;
                }
                String value = contentrole[i].replaceFirst("%$", "");
                p.addParam("java.lang.String " + unique, value);
                sclause = (String)sclause + "this.xlink.contentRole.substring(0, " + value.length() + ") == " + unique;
            }
            if (((String)sclause).length() > 0) {
                clause = clause + " && (" + (String)sclause + ")";
            }
        }
        if (before != null) {
            unique = Predicates.unique("before", before.getTime());
            clause = clause + " && this.xlink.date < " + unique;
            p.addParam("java.util.Date " + unique, before);
        }
        if (after != null) {
            unique = Predicates.unique("after", after.getTime());
            clause = clause + " && this.xlink.date > " + unique;
            p.addParam("java.util.Date " + unique, after);
        }
        p.setClause(clause);
        return p;
    }

    public static Predicate predicateXLinkForLocatorRoleContains(Database db, String role) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("role", role);
        p.setClause("this.role.indexOf(" + unique + ") != -1");
        p.addParam("java.lang.String " + unique, role);
        return p;
    }

    public static Predicate predicateXLinkForLocatorRoleContains(Database db, String[] roles) {
        Predicate p = new Predicate(db);
        Object clause = "";
        for (int i = 0; i < roles.length; ++i) {
            if (i != 0) {
                clause = (String)clause + " || ";
            }
            String unique = Predicates.unique("role", roles, i);
            clause = (String)clause + "this.role.indexOf(" + unique + ") != -1";
            p.addParam("java.lang.String " + unique, roles[i]);
        }
        p.setClause("(" + (String)clause + ")");
        return p;
    }

    private static String unique(String prefix, long i) {
        return prefix + Math.abs(i == Long.MIN_VALUE ? 0L : i);
    }

    private static String unique(String prefix, @Nullable String s) {
        if (s == null) {
            return prefix + "0";
        }
        int hash = s.hashCode();
        return prefix + Math.abs(hash == Integer.MIN_VALUE ? 0 : hash);
    }

    private static String unique(String prefix, @Nullable Collection<String> collection) {
        if (collection == null) {
            return prefix + "0";
        }
        int hash = collection.hashCode();
        return prefix + Math.abs(hash == Integer.MIN_VALUE ? 0 : hash);
    }

    private static String unique(String prefix, String[] array, int position) {
        int hash = Arrays.hashCode(array);
        return prefix + "_" + position + Math.abs(hash == Integer.MIN_VALUE ? 0 : hash);
    }
}

