/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.xmlwriter.esc;

import org.pageseeder.xmlwriter.esc.XMLEscape;
import org.pageseeder.xmlwriter.esc.XMLEscapeBase;

public final class XMLEscapeASCII
extends XMLEscapeBase
implements XMLEscape {
    public static final XMLEscape ASCII_ESCAPE = new XMLEscapeASCII();
    private static final String ENCODING = "ASCII";

    private XMLEscapeASCII() {
        super(ENCODING);
    }

    @Override
    public String toAttributeValue(char[] ch, int off, int len) {
        StringBuffer out = new StringBuffer(len + len / 10);
        for (int i = off; i < off + len; ++i) {
            if (ch[i] < ' ') {
                if (ch[i] == '\t' || ch[i] == '\n' || ch[i] == '\r') {
                    out.append(ch[i]);
                    continue;
                }
                this.doNothing();
                continue;
            }
            if (ch[i] < '\u007f') {
                switch (ch[i]) {
                    case '&': {
                        out.append("&amp;");
                        break;
                    }
                    case '<': {
                        out.append("&lt;");
                        break;
                    }
                    case '\"': {
                        out.append("&quot;");
                        break;
                    }
                    case '\'': {
                        out.append("&#x27;");
                        break;
                    }
                    default: {
                        out.append(ch[i]);
                        break;
                    }
                }
                continue;
            }
            if (ch[i] < '\u00a0') {
                this.doNothing();
                continue;
            }
            if (ch[i] >= '\ud800' && ch[i] <= '\udfff') {
                int codePoint = Character.codePointAt(ch, i, len);
                i += Character.charCount(codePoint) - 1;
                out.append("&#x").append(Integer.toHexString(codePoint)).append(';');
                continue;
            }
            out.append("&#x").append(Integer.toHexString(ch[i])).append(';');
        }
        return out.toString();
    }

    @Override
    public String toElementText(char[] ch, int off, int len) {
        StringBuffer out = new StringBuffer(len + len / 10);
        for (int i = off; i < off + len; ++i) {
            char c = ch[i];
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '\n' || c == '\r' || c == '\t') {
                out.append(c);
                continue;
            }
            if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
                this.doNothing();
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                int codePoint = Character.codePointAt(ch, i, len);
                i += Character.charCount(codePoint) - 1;
                out.append("&#x").append(Integer.toHexString(codePoint)).append(';');
                continue;
            }
            if (c > '\u009f') {
                out.append("&#x").append(Integer.toHexString(ch[i])).append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private void doNothing() {
    }
}

