/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.xref;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.URI;
import com.pageseeder.thread.ResolveXRefsThread;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(group=true, member=true, database=true)
@PublicAPI
public final class ResolveXRefs
implements Generator,
SingleCheck {
    @ContentPermission(value=EditGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        if (req.getURI() != null && !URIRule.belongsToGroup((Database)req.getDatabase(), (Long)req.getURI().getId(), (String)req.getGroup().getName())) {
            return new ForbiddenCheck();
        }
        return new EditGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URI uri = req.getURI();
        Group group = req.getGroup();
        GroupURI guri = null;
        String folderpath = null;
        if (uri != null) {
            if (!"folder".equals(uri.getType())) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NOT_A_FOLDER);
                return;
            }
            folderpath = uri.getPath() + "/";
            Group defgroup = URIRule.getDefaultGroupForURI((Database)req.getDatabase(), (Long)uri.getId());
            if (defgroup != null && defgroup.getId().longValue() != group.getId().longValue()) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.IN_ANOTHER_DEFAULT_GROUP_FOLDER, "Folder " + uri.getPath() + " is in the default group folder for group " + defgroup.getName());
                return;
            }
            for (GroupURI aguri : uri.getGroupURIsCol()) {
                if (!aguri.getGroupsCol().contains(group)) continue;
                guri = aguri;
                break;
            }
            if (guri == null) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to find group folder for folder " + uri.getPath());
                return;
            }
        } else {
            guri = GroupURIRule.getDefaultGroupURI((Group)group);
            if (guri == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NO_DEFAULT_GROUPURI);
                return;
            }
        }
        if (!"false".equals(req.getParameter((Parameter)StandardParameters.start_thread))) {
            ResolveXRefsThread thread = ResolveXRefsThread.newInstance(req.getMember().getUsername(), group, guri.getId());
            thread.setSubPath(folderpath);
            ProcessManager manager = ProcessManager.getInstance();
            manager.start((ProcessThread)thread);
            XMLWriter xml = res.getXMLWriter();
            xml.openElement("xref-resolution");
            thread.toXML(xml);
            xml.closeElement();
            res.setStatus(GeneratorStatus.ACCEPTED);
        } else {
            Long total = DatabaseQuery.getNumberURIsByGroupURIIgnoreArchiveCol((Database)req.getDatabase(), (GroupURI)guri, (String)folderpath, (!URIRule.isArchived((URI)uri) ? 1 : 0) != 0);
            XMLWriter xml = res.getXMLWriter();
            xml.element("total-uris", Long.toString(total));
        }
    }
}

