/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.xref;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(uri=true, member=true, database=true)
@PublicAPI
public final class ListURIReverseXRefs
implements Generator,
SingleCheck {
    private static final int MAX_NB_RESULTS = 1000;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(req.getURI()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Member member = req.getMember();
        int page = Long.valueOf(req.getParameter((Parameter)StandardParameters.page, 1L)).intValue();
        int pagesize = Long.valueOf(req.getParameter((Parameter)StandardParameters.pagesize, 1000L)).intValue();
        if (page < 1) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Parameter page must be larger than 0");
            return;
        }
        UserDetails userdetails = new UserDetailsManager().get(db, member.getId(), false);
        boolean admin = MemberRule.isAdministrator((Map)userdetails.flags());
        ArrayList grps = new ArrayList(userdetails.flags().keySet());
        Collection groups = GroupRule.getGroupsByNames((Database)db, grps);
        List reversexrefs = DatabaseQuery.getReverseXRefsByURIGroups((Database)db, (Long)uri.getId(), (Collection)groups, (int)page, (int)pagesize, (boolean)true);
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("reversexrefs");
        int countAll = admin && reversexrefs.size() <= pagesize && page == 1 ? reversexrefs.size() : DatabaseQuery.getReverseXRefCountByURI((Database)db, (URI)uri);
        xml.attribute("count-all-groups", countAll);
        if (reversexrefs.size() > pagesize) {
            xml.attribute("limitreached", "true");
        }
        for (int i = 0; i < reversexrefs.size() && i < pagesize; ++i) {
            XLink xl = (XLink)reversexrefs.get(i);
            XRef xref = new XRef(xl);
            xref.reverseXRefToPSML(xml, true);
        }
        xml.closeElement();
    }
}

