/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ws;

import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.URI;
import com.pageseeder.ws.Channel;
import com.pageseeder.ws.ChannelId;
import com.pageseeder.ws.ChannelManager;
import com.pageseeder.ws.Endpoint;
import com.pageseeder.ws.EndpointConfigurator;
import com.pageseeder.ws.FragmentEditingEvent;
import com.pageseeder.ws.JsonMessage;
import com.pageseeder.ws.Subscriber;
import java.io.IOException;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/ws/uris/{uriid}", configurator=EndpointConfigurator.class)
public class URIEndpoint
extends Endpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(URIEndpoint.class);
    private @Nullable ChannelId channelId = null;

    @OnOpen
    public void onOpen(Session session, @PathParam(value="uriid") String param) {
        LOGGER.debug("Open Sub#{}", (Object)this.getConnectionId());
        this.setSession(session);
        try {
            ChannelId id;
            long uriid = Long.parseLong(param);
            if (!this.hasEditPermission(uriid)) {
                this.closeSilently(session, new CloseReason(UNAUTHORIZED, "No permission URI ID"));
                return;
            }
            this.channelId = id = ChannelManager.get().getId(Channel.Type.URI_EDITING, uriid);
            ChannelManager.get().registerAndSubscribe(id, new Subscriber<URIEndpoint>(this));
            LOGGER.debug("Created subscriber {} for channel {}", (Object)this.getConnectionId(), (Object)id);
        }
        catch (IllegalArgumentException ex) {
            this.closeSilently(session, new CloseReason(BAD_REQUEST, "Invalid URI ID"));
        }
        catch (Exception ex) {
            LOGGER.error("Error opening Sub#{}: {}", new Object[]{this.getConnectionId(), ex.getMessage(), ex});
        }
    }

    @OnClose
    public void end(CloseReason reason) {
        try {
            LOGGER.debug("Close Sub#{} ({}) due to {}", new Object[]{this.getConnectionId(), this.getUsername(), reason});
            ChannelManager.get().unsubscribe(this.channelId, this.getConnectionId());
        }
        catch (Exception ex) {
            LOGGER.error("Error closing Sub#{}: {}", new Object[]{this.getConnectionId(), ex.getMessage(), ex});
        }
    }

    @OnMessage
    public void incoming(String message) {
        try {
            LOGGER.debug("Incoming Sub#{} ({}): {}", new Object[]{this.getConnectionId(), this.getUsername(), message});
            FragmentEditingEvent event = FragmentEditingEvent.parse(message);
            if (event != null) {
                ChannelManager.get().post(this.channelId, event);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Error Sub#{}: Unable to parse message", (Object)this.getConnectionId(), (Object)ex);
        }
    }

    @OnError
    public void onError(Throwable t) {
        if (t.getMessage() != null) {
            LOGGER.warn("Error Sub#{}: {}", (Object)this.getConnectionId(), (Object)t.getMessage());
        }
    }

    @Override
    public synchronized void post(JsonMessage message) {
        LOGGER.debug("Post Sub#{} ({}): {}", new Object[]{this.getConnectionId(), this.getUsername(), message});
        this.sendAsync(message, () -> ChannelManager.get().unsubscribe(this.channelId, this.getConnectionId()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasEditPermission(long uriid) throws IOException {
        Long memberId = this.getMemberId();
        if (memberId == null) {
            this.close(UNAUTHORIZED, "Unauthorized");
            return false;
        }
        try (Database db = Database.open();){
            Permissions perm;
            URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
            if (uri == null) {
                this.close(BAD_REQUEST, "Invalid URI ID");
                boolean bl = false;
                return bl;
            }
            UserDetails userdetails = new UserDetailsManager().get(db, memberId);
            if (PermissionManager.check((Long)memberId, (UserDetails)userdetails, (Database)db, (Permissions)(perm = new Permissions()), (PermissionCheck)new EditURICheck(uri))) return true;
            this.close(FORBIDDEN, "Forbidden");
            boolean bl = false;
            return bl;
        }
        catch (DatabaseException ex) {
            LOGGER.error("Database error: {}", (Object)ex.getMessage(), (Object)ex);
            return false;
        }
    }

    private void closeSilently(Session session, CloseReason reason) {
        try {
            LOGGER.debug("Closing Sub#{}: {}", (Object)this.getConnectionId(), (Object)reason);
            session.close(reason);
        }
        catch (Exception ex) {
            LOGGER.error("Error closing Sub#{}: {}", new Object[]{this.getConnectionId(), ex.getMessage(), ex});
        }
    }
}

