/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ws;

import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.ws.ChannelId;
import com.pageseeder.ws.ChannelManager;
import com.pageseeder.ws.Endpoint;
import com.pageseeder.ws.EndpointConfigurator;
import com.pageseeder.ws.JsonMessage;
import com.pageseeder.ws.Subscriber;
import java.io.IOException;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/ws/logs/recent", configurator=EndpointConfigurator.class)
public class RecentLogsEndpoint
extends Endpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecentLogsEndpoint.class);

    @OnOpen
    public void onOpen(Session session) {
        try {
            LOGGER.debug("Open Sub#{}", (Object)this.getConnectionId());
            this.setSession(session);
            if (!this.hasAdminPermission()) {
                return;
            }
            ChannelManager.get().registerAndSubscribe(ChannelId.RECENT_LOGS, new Subscriber<RecentLogsEndpoint>(this));
            LOGGER.debug("Created subscriber {} for channel {}", (Object)this.getConnectionId(), (Object)ChannelId.RECENT_LOGS);
        }
        catch (Exception ex) {
            LOGGER.error("Error opening Sub#{}: {}", new Object[]{this.getConnectionId(), ex.getMessage(), ex});
        }
    }

    @OnClose
    public void end(CloseReason reason) {
        try {
            LOGGER.debug("Close Sub#{} ({}) due to {}", new Object[]{this.getConnectionId(), this.getUsername(), reason});
            ChannelManager.get().unsubscribe(ChannelId.RECENT_LOGS, this.getConnectionId());
        }
        catch (Exception ex) {
            LOGGER.error("Error closing Sub#{}: {}", new Object[]{this.getConnectionId(), ex.getMessage(), ex});
        }
    }

    @OnError
    public void onError(Throwable t) {
        LOGGER.error("Error Sub#{} ({}): {}", new Object[]{this.getConnectionId(), this.getUsername(), t.getMessage(), t});
    }

    @Override
    public synchronized void post(JsonMessage message) {
        LOGGER.debug("Post Sub#{} ({}): {}", new Object[]{this.getConnectionId(), this.getUsername(), message});
        this.sendAsync(message, () -> ChannelManager.get().unsubscribe(ChannelId.RECENT_LOGS, this.getConnectionId()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAdminPermission() throws IOException {
        Long memberId = this.getMemberId();
        if (memberId == null) {
            this.close(UNAUTHORIZED, "Unauthorized");
            return false;
        }
        try (Database db = Database.open();){
            UserDetails userdetails = new UserDetailsManager().get(db, memberId);
            if (PermissionManager.check((Long)memberId, (UserDetails)userdetails, (Database)db, (Permissions)new Permissions(), (PermissionCheck)new AdminSystemCheck())) return true;
            this.close(FORBIDDEN, "Forbidden");
            boolean bl = false;
            return bl;
        }
        catch (DatabaseException ex) {
            LOGGER.error("Database error", (Throwable)ex);
            return false;
        }
    }
}

