/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ws;

import com.pageseeder.ws.ChannelId;
import com.pageseeder.ws.JsonMessage;
import com.pageseeder.ws.Subscriber;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;

public final class Channel {
    private final ChannelId id;
    private final Map<Long, Subscriber<?>> subscribers = new ConcurrentHashMap();

    public Channel(ChannelId id) {
        this.id = id;
    }

    public ChannelId getId() {
        return this.id;
    }

    public void subscribe(Subscriber<?> subscriber) {
        this.subscribers.putIfAbsent(subscriber.getId(), subscriber);
    }

    public void unsubscribe(@Nullable Long subscriberId) {
        if (subscriberId == null) {
            return;
        }
        this.subscribers.remove(subscriberId);
    }

    public void post(JsonMessage message) {
        this.subscribers.forEach((subscriberId, subscriber) -> subscriber.post(message));
    }

    public boolean isEmpty() {
        return this.subscribers.isEmpty();
    }

    public static enum Type {
        URI_EDITING,
        LOGS;

    }
}

