/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

public class Range {
    private final long start;
    private final long end;

    public Range(long start, long end) {
        if (start > end || start < 0L) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.end = end;
    }

    public static Range fromString(String range, long total) throws IllegalArgumentException {
        int i = range.indexOf(45);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        String first = range.substring(0, i);
        String second = range.substring(i + 1);
        try {
            if (first.isEmpty()) {
                long start = total - Long.parseLong(second);
                if (start < 0L) {
                    start = 0L;
                }
                return new Range(start, total - 1L);
            }
            if (second.isEmpty()) {
                return new Range(Long.parseLong(first), total - 1L);
            }
            long end = Long.parseLong(second);
            if (end > total - 1L) {
                end = total - 1L;
            }
            return new Range(Long.parseLong(first), end);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException();
        }
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public long length() {
        return this.end - this.start + 1L;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Range)) {
            return false;
        }
        return this.start == ((Range)o).start && this.end == ((Range)o).end;
    }

    public int hashCode() {
        int result = Long.hashCode(this.start);
        result = 31 * result + Long.hashCode(this.end);
        return result;
    }

    public String toString() {
        return this.start + "-" + this.end;
    }
}

