/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.url;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.url.URLConfig;
import com.pageseeder.base.url.URLFiles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLUtils.class);

    private URLUtils() {
    }

    public static @Nullable URLConfig findURLConfig(URL url, @Nullable String type, @Nullable String mediatype) throws FoundationException {
        if (type != null) {
            try {
                return URLFiles.loadURLConfig((String)type, null);
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to load URL config file for type {}", (Object)type, (Object)ex);
                throw new FoundationException("Failed to load URL config file for type " + type);
            }
        }
        return URLUtils.findByDomainMediatype(url.getHost(), mediatype);
    }

    private static @Nullable URLConfig findByDomainMediatype(String domain, @Nullable String mediatype) {
        ArrayList types = new ArrayList(URLFiles.listAvailableTypes(null));
        Collections.sort(types);
        URLConfig anyDomainsOrMediatypes = null;
        ArrayList<URLConfig> mediatypeDomainMatches = new ArrayList<URLConfig>();
        ArrayList<URLConfig> domainMatches = new ArrayList<URLConfig>();
        ArrayList<URLConfig> mediatypeMatches = new ArrayList<URLConfig>();
        for (String type : types) {
            try {
                URLConfig config = URLFiles.loadURLConfig((String)type, null);
                if (config == null) continue;
                if (anyDomainsOrMediatypes == null && config.matchAnyDomain() && config.matchAnyMediatype()) {
                    anyDomainsOrMediatypes = config;
                }
                if (mediatype != null && config.matchMediatypes(mediatype) && config.matchDomain(domain)) {
                    mediatypeDomainMatches.add(config);
                }
                if (config.matchDomain(domain) && config.matchAnyMediatype()) {
                    domainMatches.add(config);
                }
                if (mediatype == null || !config.matchMediatypes(mediatype) || !config.matchAnyDomain()) continue;
                mediatypeMatches.add(config);
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to load URL config file for type {}", (Object)type, (Object)ex);
            }
        }
        if (!mediatypeDomainMatches.isEmpty()) {
            return (URLConfig)mediatypeDomainMatches.get(0);
        }
        if (!domainMatches.isEmpty()) {
            return (URLConfig)domainMatches.get(0);
        }
        if (!mediatypeMatches.isEmpty()) {
            return (URLConfig)mediatypeMatches.get(0);
        }
        return anyDomainsOrMediatypes;
    }
}

