/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.url.URLMetadataExtractor;
import com.pageseeder.utils.MemberTempFiles;
import com.pageseeder.validation.SchematronValidationManager;
import com.pageseeder.validation.ValidationResults;
import com.pageseeder.validation.Validators;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;

public final class ValidateThread
extends ProcessThread {
    private static final String SITE_PREFIX = GlobalSettings.getSitePrefix();
    private static final String PRIVATE_FILE_NAME = "validation_output.xml";
    private static final int MAX_OUTPUT_SIZE = 10000000;
    private int outputSize = 0;
    private String outputFilename = "validation_output.xml";
    private final Queue<Long> urisToValidate = new LinkedList<Long>();
    private boolean logMessages = true;
    private boolean failuresOnly = false;
    private final String schematron;
    private int currentProgress = 0;
    private int totalUris = 0;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private boolean throttle = false;

    private ValidateThread(String membername, Group group, String sch) {
        super(membername, "Validation thread for group " + group.getName(), group);
        this.schematron = sch;
        this.attributes.put("date", ISO8601.format((long)new Date().getTime(), (ISO8601)ISO8601.DATETIME));
        this.attributes.put("schema", this.schematron);
    }

    public void setOutputFilename(String filename) {
        this.outputFilename = filename;
    }

    public void setLogMessages(boolean logmessages) {
        this.logMessages = logmessages;
    }

    public void setFailuresOnly(boolean failuresonly) {
        this.failuresOnly = failuresonly;
    }

    public void addURIToValidate(Long uriid) {
        if (!this.urisToValidate.contains(uriid)) {
            this.urisToValidate.add(uriid);
        }
    }

    public void setReportAttribute(@Nullable String name, @Nullable String value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.totalUris);
        out.field("current", (long)this.currentProgress);
        out.endObject();
    }

    public void process() {
        this.run(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@Nullable Database database, @Nullable Transaction transaction) {
        if (this.urisToValidate.isEmpty()) {
            this.updateStatus(ProcessStage.Status.FAILED, "No documents to validate!", this.logMessages);
            return;
        }
        this.totalUris = this.urisToValidate.size();
        Transaction tr = transaction;
        Database db = database;
        boolean newTransaction = false;
        if (db == null && tr == null) {
            try {
                db = Database.open();
                tr = new Transaction(db);
                newTransaction = true;
            }
            catch (OpenDatabaseException e) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to open database", this.logMessages);
                return;
            }
        }
        Long uriid = null;
        try {
            XMLWriterImpl output;
            if (newTransaction) {
                tr.begin();
            }
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.getGroupID());
            Member mem = DatabaseQuery.getMemberByUsername((Database)db, (String)this.getUsername());
            File folder = PRIVATE_FILE_NAME.equals(this.outputFilename) ? MemberTempFiles.getTempFolder(mem, group) : MemberTempFiles.getTempFolder("shared/validation", group.getName());
            File validationReport = new File(folder, this.outputFilename);
            try {
                if (!validationReport.exists() && !validationReport.createNewFile()) {
                    throw new IOException("Failed to create output document " + validationReport.getAbsolutePath());
                }
                output = new XMLWriterImpl((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(validationReport), StandardCharsets.UTF_8), true);
                output.openElement("validation-report", true);
                output.attribute("documents", this.totalUris);
                output.attribute("failures-only", this.failuresOnly ? "true" : "false");
                output.attribute("log-message", this.logMessages ? "true" : "false");
                for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
                    output.attribute(attribute.getKey(), attribute.getValue());
                }
            }
            catch (IOException ex) {
                this.fail("Failed to create validation output: " + ex.getMessage());
                if (newTransaction) {
                    tr.abort();
                }
                if (newTransaction) {
                    db.close();
                    db = null;
                }
                return;
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + this.totalUris + " documents to validate.");
            HashMap<String, String> cache = new HashMap<String, String>();
            boolean oneValidated = false;
            XMLStringWriter validationXML = new XMLStringWriter(XML.NamespaceAware.No);
            ArrayList<String> ids = new ArrayList<String>();
            while (this.urisToValidate.peek() != null) {
                uriid = this.urisToValidate.remove();
                if (this.wasCancelled()) break;
                ++this.currentProgress;
                URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                if (uri == null || ValidateThread.isArchived(uri, group)) continue;
                if (this.wasCancelled()) break;
                if (this.throttle && uri.getExternal().booleanValue() && URLMetadataExtractor.delayHostRequest(uri.getHost().getName())) {
                    this.urisToValidate.add(uri.getId());
                    --this.currentProgress;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                ids.add(uri.getId().toString());
                boolean validated = this.doValidate(db, group, uri, mem, (XMLWriter)validationXML, cache);
                if (this.outputSize > 10000000) {
                    validationXML.emptyElement("limitreached");
                    break;
                }
                if (validated) {
                    oneValidated = true;
                }
                if (!newTransaction) continue;
                tr.commitAndStart();
            }
            output.attribute("ids", String.join((CharSequence)",", ids));
            output.writeXML(validationXML.toString());
            try {
                output.closeElement();
                output.close();
            }
            catch (IOException e) {
                this.fail("Failed to close output writer");
            }
            if (!oneValidated) {
                this.fail("Documents were not validated, see process logs for more details");
                validationReport.delete();
            }
            this.complete("OUTPUT:" + this.outputFilename);
            if (newTransaction) {
                tr.commit();
            }
        }
        catch (StartTransactionException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to start transaction", this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
        }
        catch (QueryFailedException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to run database query for URIID " + uriid + ": " + e.getMessage(), this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
        }
        catch (CommitTransactionException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to commit transaction", this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
        }
        catch (Throwable e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to validate URIID " + uriid + ": " + e.getMessage(), this.logMessages);
            if (newTransaction) {
                tr.abort();
            }
        }
        finally {
            if (newTransaction) {
                db.close();
                db = null;
            }
        }
    }

    public static ValidateThread newInstance(String username, Group group, String schema) {
        return new ValidateThread(username, group, schema);
    }

    private boolean doValidate(Database db, Group group, URI uri, Member mem, XMLWriter output, Map<String, String> cache) {
        String svrl;
        ValidationResults results;
        String objtype;
        SchematronValidationManager validator = SchematronValidationManager.getInstance();
        boolean external = uri.getExternal();
        String path = (external ? URIRule.getHostURL((URI)uri) : "") + uri.getDecodedPath();
        String string = objtype = external ? "URL " : "Document ";
        if (this.isDefaultSchema()) {
            results = validator.getValidationResults(group, uri, mem, db, cache);
        } else {
            File schema = Validators.findSchema(group, uri, this.schematron);
            results = validator.validate(group, uri, schema, mem, db, cache);
        }
        if (results.wasSchemaNotFound()) {
            this.updateStatus(ProcessStage.Status.WARNING, "No " + this.schematron + " found for " + objtype + path);
            return false;
        }
        if (results.urlMetadataRequested()) {
            this.throttle = true;
        }
        if ((svrl = results.getSVRLResults()) == null) {
            String message = results.getErrorMessage() != null ? "Could not validate " + objtype + "with " + this.schematron : results.getErrorMessage();
            this.updateStatus(ProcessStage.Status.ERROR, message);
            return false;
        }
        try {
            if (!results.isValid()) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, objtype + path + " is invalid");
            } else {
                this.updateStatus(ProcessStage.Status.INPROGRESS, objtype + path + " is valid.");
            }
            if (!results.isValid() || !this.failuresOnly) {
                this.outputSize += svrl.length() + path.length() + 30;
                output.openElement("uri", true);
                output.attribute("id", uri.getId().toString());
                output.attribute("path", path);
                output.attribute("title", uri.getDisplayTitle());
                if (uri.getDocID() != null) {
                    output.attribute("docid", uri.getDocID());
                }
                output.writeXML(svrl);
                output.closeElement();
            }
        }
        catch (IOException ex) {
            this.updateStatus(ProcessStage.Status.ERROR, "Failed to write output for " + objtype + path + ": " + ex.getMessage(), this.logMessages);
        }
        return true;
    }

    private boolean isDefaultSchema() {
        return "default".equals(this.schematron) || "default.sch".equals(this.schematron);
    }

    private static boolean isArchived(URI uri, Group group) {
        return uri.getPath().startsWith(SITE_PREFIX + "/" + group.getName().replace('-', '/') + "/archive/");
    }
}

