/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.system;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.utils.SessionTracker;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;

@Output(types={OutputType.JSON, OutputType.XML})
public final class ListActiveSessions
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Collection<SessionTracker.TrackedSession> sessions = SessionTracker.getTrackedSessions();
        UniversalPrinter out = res.getUniversalWriter();
        out.startCollection("sessions");
        for (SessionTracker.TrackedSession session : sessions) {
            out.startObject("session");
            out.field("username", session.username());
            LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(session.since()), ZoneId.systemDefault());
            out.field("since", date.toString());
            out.field("timeout", (long)session.timeout());
            out.endObject();
        }
        out.endCollection();
    }
}

