/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.system;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.pageseeder.xmlwriter.XMLWriter;

public final class GetCPUTime
implements Generator,
SingleCheck {
    private static final long DEFAULT_SAMPLING_INTERVAL = 100L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        XMLWriter xml = res.getXMLWriter();
        long interval = req.getParameter((Parameter)StandardParameters.interval, 100L);
        if (interval <= 0L || interval > 1000L) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Interval must be between 1 and 1000");
            return;
        }
        long threadId = req.getParameter((Parameter)StandardParameters.thread, -1L);
        this.process(interval, threadId, xml);
        xml.flush();
    }

    public void process(long interval, long threadId, XMLWriter xml) throws IOException {
        try {
            Sample end;
            Sample start;
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (threadId == -1L) {
                long current = Thread.currentThread().getId();
                start = this.global(bean, current);
                Thread.sleep(interval);
                end = this.global(bean, current);
            } else {
                start = this.single(bean, threadId);
                Thread.sleep(interval);
                end = this.single(bean, threadId);
            }
            long time = end.time() - start.time();
            long user = end.user() - start.user();
            long cpu = end.cpu() - start.cpu();
            xml.openElement("sample");
            xml.attribute("interval", Long.toString(interval));
            xml.attribute("cpu", Long.toString(cpu * 100L / time));
            xml.attribute("user", Long.toString(user * 100L / time));
            xml.attribute("system", Long.toString((cpu - user) * 100L / time));
            xml.closeElement();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("CPU time sampling was interrupted", ex);
        }
    }

    private Sample global(ThreadMXBean bean, long current) {
        long[] ids;
        long cpu = 0L;
        long user = 0L;
        for (long id : ids = bean.getAllThreadIds()) {
            if (id == current) continue;
            long c = bean.getThreadCpuTime(id);
            long u = bean.getThreadUserTime(id);
            if (c == -1L || u == -1L) continue;
            cpu += c;
            user += u;
        }
        return new Sample(cpu, user);
    }

    private Sample single(ThreadMXBean bean, long id) {
        long cpu = bean.getThreadCpuTime(id);
        long user = bean.getThreadUserTime(id);
        if (cpu == -1L || user == -1L) {
            return new Sample(0L, 0L);
        }
        return new Sample(cpu, user);
    }

    private static class Sample {
        private final long time = System.nanoTime();
        private final long cpu;
        private final long user;

        public Sample(long cpu, long user) {
            this.cpu = cpu;
            this.user = user;
        }

        public long cpu() {
            return this.cpu;
        }

        public long user() {
            return this.user;
        }

        public long time() {
            return this.time;
        }
    }
}

